/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ColumnIDUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ClientPluginFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Text;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class MaterialDisambiguationGrid
extends TypedTableGrid<Material> {
    private static final String BROWSER_ID = "openbis_material-disambiguation-grid";
    private final WellSearchCriteria searchCriteria;
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;

    public static void openTab(final IViewContext<IScreeningClientServiceAsync> viewContext, final WellSearchCriteria searchCriteria, final String nothingFoundRedirectionUrlOrNull) {
        boolean refreshAutomatically = false;
        MaterialDisambiguationGrid grid = new MaterialDisambiguationGrid(viewContext, searchCriteria, refreshAutomatically);
        final AbstractTabItemFactory disambiguationTabFactory = MaterialDisambiguationGrid.createDisambiguationTab(viewContext, searchCriteria, grid);
        grid.refresh(new IDataRefreshCallback(){
            private boolean firstCall = true;

            @Override
            public void postRefresh(boolean wasSuccessful) {
                if (!this.firstCall) {
                    return;
                }
                this.firstCall = false;
                if (MaterialDisambiguationGrid.this.getRowNumber() == 0) {
                    if (nothingFoundRedirectionUrlOrNull != null) {
                        String url = URL.decodeQueryString((String)nothingFoundRedirectionUrlOrNull);
                        WindowUtils.redirect(url, "_top");
                    } else {
                        AbstractTabItemFactory tabFactory = MaterialDisambiguationGrid.createNoResultsTab(viewContext, searchCriteria);
                        DispatcherHelper.dispatchNaviEvent(tabFactory);
                    }
                } else if (MaterialDisambiguationGrid.this.getRowNumber() == 1) {
                    List materials = MaterialDisambiguationGrid.this.getContainedGridElements();
                    Material material = (Material)materials.get(0);
                    MaterialDisambiguationGrid.this.openMaterialDetailViewer(material);
                } else {
                    DispatcherHelper.dispatchNaviEvent(disambiguationTabFactory);
                }
            }
        }, false);
    }

    private static AbstractTabItemFactory createNoResultsTab(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria searchCriteria) {
        boolean searchAllExperiments = searchCriteria.getExperimentCriteria().tryGetExperiment() == null;
        String msgDictKey = searchAllExperiments ? "WELL_SEARCH_NO_RESULTS_IN_ANY_EXP_FOUND" : "WELL_SEARCH_NO_RESULTS_IN_SELECTED_EXP_FOUND";
        Text component = new Text(viewContext.getMessage(msgDictKey, new Object[0]));
        return MaterialDisambiguationGrid.createSimpleTab(viewContext, (Component)component, "MATERIAL_DISAMBIGUATION_TITLE", "well-search-no-results");
    }

    private static AbstractTabItemFactory createSimpleTab(final IViewContext<?> viewContext, final Component component, final String titleDictKey, final String idSuffix) {
        return new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                return DefaultTabItem.createUnaware(this.getTabTitle(), component, false, viewContext);
            }

            @Override
            public String getId() {
                return "openbis_" + idSuffix;
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return null;
            }

            @Override
            public String getTabTitle() {
                return viewContext.getMessage(titleDictKey, new Object[0]);
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    private static AbstractTabItemFactory createDisambiguationTab(final IViewContext<IScreeningClientServiceAsync> viewContext, final WellSearchCriteria searchCriteria, MaterialDisambiguationGrid grid) {
        return new AbstractTabItemFactory(){
            private final String reportDate = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_MEDIUM).format(new Date());

            @Override
            public ITabItem create() {
                return DefaultTabItem.create(this.getTabTitle(), MaterialDisambiguationGrid.this.asDisposableWithoutToolbar(), viewContext);
            }

            @Override
            public String getId() {
                return "openbis_-MaterialDisambiguationGrid-" + this.reportDate;
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return HelpPageIdentifier.createSpecific("Material Disambiguation");
            }

            @Override
            public String getTabTitle() {
                return viewContext.getMessage("MATERIAL_DISAMBIGUATION_TITLE", new Object[0]);
            }

            @Override
            public String tryGetLink() {
                return ScreeningLinkExtractor.tryCreateWellsSearchLink(searchCriteria, false);
            }
        };
    }

    private MaterialDisambiguationGrid(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria searchCriteria, boolean refreshAutomatically) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, refreshAutomatically, ScreeningDisplayTypeIDGenerator.MATERIAL_DISAMBIGUATION_GRID);
        this.screeningViewContext = viewContext;
        this.searchCriteria = searchCriteria;
        this.setHeader(viewContext.getMessage("MATERIAL_DISAMBIGUATION_GRID_EXPLANATION", new Object[0]));
        this.linkToMaterialDetails();
        this.setBorders(true);
    }

    private void linkToMaterialDetails() {
        ICellListenerAndLinkGenerator<Material> listenerLinkGenerator = new ICellListenerAndLinkGenerator<Material>(){

            @Override
            public String tryGetLink(Material material, ISerializableComparable value) {
                return ScreeningLinkExtractor.createMaterialDetailsLink((IEntityInformationHolder)material, MaterialDisambiguationGrid.this.searchCriteria.getExperimentCriteria());
            }

            @Override
            public void handle(TableModelRowWithObject<Material> row, boolean specialKeyPressed) {
                Material material = row.getObjectOrNull();
                MaterialDisambiguationGrid.this.openMaterialDetailViewer(material);
            }
        };
        this.registerListenerAndLinkGenerator("CODE", listenerLinkGenerator);
        String detailsLinkPropertyTypeName = this.screeningViewContext.getPropertyOrNull("material-details-property-type");
        if (detailsLinkPropertyTypeName != null) {
            String detailsLinkPropertyColumnId = ColumnIDUtils.getColumnIdForProperty("property-", detailsLinkPropertyTypeName);
            this.registerListenerAndLinkGenerator(detailsLinkPropertyColumnId, listenerLinkGenerator);
        }
    }

    private void openMaterialDetailViewer(Material material) {
        ClientPluginFactory.openImagingMaterialViewer(material, this.searchCriteria.getExperimentCriteria(), this.searchCriteria.getAnalysisProcedureCriteria(), false, this.screeningViewContext);
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Material>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Material>> callback) {
        this.screeningViewContext.getService().listMaterials(resultSetConfig, this.searchCriteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Material>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.screeningViewContext.getService().prepareExportMaterials(exportCriteria, callback);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE");
    }
}

