/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.AnalysisProcedureListenerHolder;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaFeatureSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;

public class MaterialReplicaFeatureSummaryGrid
extends TypedTableGrid<MaterialReplicaFeatureSummary> {
    private static final String ID = "material_replica_feature_summary";
    private static final String PREFIX = "openbis_material_replica_feature_summary";
    public static final String BROWSER_ID = "openbis_material_replica_feature_summary_main";
    private final IViewContext<IScreeningClientServiceAsync> specificViewContext;
    private final TechId experimentId;
    private final TechId materialId;
    private WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;

    public static IDisposableComponent createForEmbeddedMode(IViewContext<IScreeningClientServiceAsync> viewContext, TechId experimentId, TechId materialId, WellSearchCriteria.AnalysisProcedureCriteria selectedAnalysisProcedure) {
        assert (selectedAnalysisProcedure != null) : "selected analysis procedure cannot be null";
        return new MaterialReplicaFeatureSummaryGrid(viewContext, experimentId, materialId, selectedAnalysisProcedure, null).asDisposableWithoutToolbar();
    }

    public static IDisposableComponent create(IViewContext<IScreeningClientServiceAsync> viewContext, TechId experimentId, TechId materialId, AnalysisProcedureListenerHolder analysisProcedureListenerHolder) {
        assert (analysisProcedureListenerHolder != null) : "must not be null. Otherwise analysis procedure selection changes won't be visible to the grid.";
        return new MaterialReplicaFeatureSummaryGrid(viewContext, experimentId, materialId, null, analysisProcedureListenerHolder).asDisposableWithoutToolbar();
    }

    MaterialReplicaFeatureSummaryGrid(IViewContext<IScreeningClientServiceAsync> viewContext, TechId experimentId, TechId materialId, WellSearchCriteria.AnalysisProcedureCriteria initialAnalysisProcedureOrNull, AnalysisProcedureListenerHolder analysisProcedureListenerHolderOrNull) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, initialAnalysisProcedureOrNull != null, DisplayTypeIDGenerator.MATERIAL_REPLICA_SUMMARY_SECTION);
        this.specificViewContext = viewContext;
        this.experimentId = experimentId;
        this.materialId = materialId;
        this.analysisProcedureCriteria = initialAnalysisProcedureOrNull;
        this.setBorders(true);
        if (analysisProcedureListenerHolderOrNull != null) {
            AnalysisProcedureChooser.IAnalysisProcedureSelectionListener analysisProcedureListener = this.createAnalysisProcedureListener();
            analysisProcedureListenerHolderOrNull.setAnalysisProcedureListener(analysisProcedureListener);
        }
    }

    private AnalysisProcedureChooser.IAnalysisProcedureSelectionListener createAnalysisProcedureListener() {
        return new AnalysisProcedureChooser.IAnalysisProcedureSelectionListener(){

            @Override
            public void analysisProcedureSelected(WellSearchCriteria.AnalysisProcedureCriteria criteria) {
                MaterialReplicaFeatureSummaryGrid.this.analysisProcedureCriteria = criteria;
                MaterialReplicaFeatureSummaryGrid.this.refresh(true);
            }
        };
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<MaterialReplicaFeatureSummary>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<MaterialReplicaFeatureSummary>> callback) {
        WellSearchCriteria.MaterialFeaturesOneExpCriteria criteria = new WellSearchCriteria.MaterialFeaturesOneExpCriteria(this.materialId, this.analysisProcedureCriteria, this.experimentId);
        this.specificViewContext.getService().listMaterialReplicaFeatureSummary(resultSetConfig, criteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<MaterialReplicaFeatureSummary>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.specificViewContext.getService().prepareExportMaterialReplicaFeatureSummary(exportCriteria, callback);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return "material_replica_feature_summary_" + columnID.toUpperCase();
    }

    public void dispose() {
        this.asDisposableWithoutToolbar().dispose();
    }
}

