/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.LayoutUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.PlateLayouter;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateImages;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;

public class PlateLayoutDatasetSection
extends TabContent {
    private final TechId datasetId;

    public PlateLayoutDatasetSection(ScreeningViewContext viewContext, TechId datasetId) {
        super("Plate Layout", viewContext, datasetId);
        this.datasetId = datasetId;
        this.setIds(DisplayTypeIDGenerator.PLATE_LAYOUT_DATASET_SECTION);
    }

    private ScreeningViewContext getViewContext() {
        return (ScreeningViewContext)this.viewContext;
    }

    @Override
    protected void showContent() {
        ScreeningViewContext context = this.getViewContext();
        this.add((Component)new Text(context.getMessage("load_in_progress", new Object[0])));
        ((IScreeningClientServiceAsync)context.getService()).getPlateContentForDataset(this.datasetId, this.createDisplayPlateCallback());
    }

    private AsyncCallback<PlateImages> createDisplayPlateCallback() {
        return new AbstractAsyncCallback<PlateImages>((IViewContext)this.getViewContext()){

            @Override
            protected void process(PlateImages plateContent) {
                PlateLayoutDatasetSection.this.removeAll();
                PlateLayoutDatasetSection.this.setLayout((Layout)new RowLayout());
                PlateLayoutDatasetSection.this.setScrollMode(Style.Scroll.AUTO);
                PlateLayoutDatasetSection.this.renderPlate(plateContent);
                PlateLayoutDatasetSection.this.layout();
            }
        };
    }

    private void renderPlate(PlateImages plateImages) {
        LayoutContainer container = new LayoutContainer();
        container.add(PlateLayouter.createVisualization(plateImages, this.getViewContext()));
        this.add((Widget)container, (LayoutData)LayoutUtils.createRowLayoutSurroundingData());
    }
}

