/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ExperimentChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import java.util.List;

class SingleOrAllExperimentsChooser
extends LayoutContainer {
    private static final String SINGLE_EXPERIMENT_TEXT = "Single experiment";
    private static final String ALL_EXPERIMENTS_TEXT = "All experiments";
    private static final String ALL_EXPERIMENTS_FROM_PROJECT_TEXT = "All experiments from ";
    private static final String CHOOSE_ONE_EXPERIMENT_TEXT = "Choose one experiment...";
    private WellSearchCriteria.SingleExperimentSearchCriteria singleExperimentChooserStateOrNull;
    private final IViewContext<?> viewContext;
    private final IDelegatedAction refreshAction;
    private final WellSearchCriteria.ExperimentSearchCriteriaHolder experimentCriteriaHolder;
    private final boolean restrictGlobalScopeLinkToProject;

    public SingleOrAllExperimentsChooser(IViewContext<?> viewContext, WellSearchCriteria.ExperimentSearchCriteriaHolder experimentCriteriaHolder, boolean restrictGlobalScopeLinkToProject, IDelegatedAction refreshAction) {
        this.viewContext = viewContext;
        this.experimentCriteriaHolder = experimentCriteriaHolder;
        this.restrictGlobalScopeLinkToProject = restrictGlobalScopeLinkToProject;
        this.refreshAction = refreshAction;
        ExperimentChooserField.ExperimentChooserFieldAdaptor singleExperimentChooser = this.createSingleExperimentChooser();
        RadioGroup experimentRadioChooser = this.createExperimentRadio(singleExperimentChooser);
        this.setWidth(380);
        this.add((Component)experimentRadioChooser);
        this.add((Component)singleExperimentChooser.getField());
    }

    public SingleOrAllExperimentsChooser(IViewContext<?> viewContext, WellSearchCriteria.ExperimentSearchCriteriaHolder experimentCriteriaHolder, IDelegatedAction refreshAction) {
        this(viewContext, experimentCriteriaHolder, false, refreshAction);
    }

    private WellSearchCriteria.ExperimentSearchCriteria tryGetExperimentSearchCriteria() {
        return this.experimentCriteriaHolder.tryGetCriteria();
    }

    private boolean isAllExperimentsChoosen() {
        WellSearchCriteria.ExperimentSearchCriteria criteriaOrNull = this.tryGetExperimentSearchCriteria();
        return criteriaOrNull == null || criteriaOrNull.tryGetExperiment() == null;
    }

    private ExperimentChooserField.ExperimentChooserFieldAdaptor createSingleExperimentChooser() {
        ExperimentChooserField.ExperimentChooserFieldAdaptor experimentChooser = ExperimentChooserField.create("", true, null, this.viewContext.getCommonViewContext());
        final ExperimentChooserField chooserField = experimentChooser.getChooserField();
        chooserField.addChosenEntityListener(new IChosenEntitiesListener<TableModelRowWithObject<Experiment>>(){

            @Override
            public void entitiesChosen(List<TableModelRowWithObject<Experiment>> rows) {
                if (!rows.isEmpty()) {
                    SingleOrAllExperimentsChooser.this.chooseSingleExperiment(chooserField, rows.get(0).getObjectOrNull());
                }
            }
        });
        chooserField.setEditable(false);
        WellSearchCriteria.ExperimentSearchCriteria criteriaOrNull = this.tryGetExperimentSearchCriteria();
        if (criteriaOrNull == null || criteriaOrNull.tryGetExperiment() == null) {
            this.singleExperimentChooserStateOrNull = null;
            chooserField.reset();
        } else {
            this.updateSingleExperimentChooser(chooserField, criteriaOrNull.tryGetExperiment());
        }
        if (criteriaOrNull == null || criteriaOrNull.tryGetExperiment() != null) {
            chooserField.setEmptyText(CHOOSE_ONE_EXPERIMENT_TEXT);
        } else {
            chooserField.setEmptyText(ALL_EXPERIMENTS_TEXT);
        }
        return experimentChooser;
    }

    private RadioGroup createExperimentRadio(final ExperimentChooserField.ExperimentChooserFieldAdaptor singleExperimentChooser) {
        RadioGroup experimentRadio = new RadioGroup();
        experimentRadio.setSelectionRequired(true);
        experimentRadio.setOrientation(Style.Orientation.HORIZONTAL);
        experimentRadio.addStyleName("default-text");
        final Radio allExps = new Radio();
        if (this.restrictGlobalScopeLinkToProject) {
            String projectIdentifier = this.experimentCriteriaHolder.tryGetCriteria().tryGetProjectIdentifier().toString();
            allExps.setBoxLabel(ALL_EXPERIMENTS_FROM_PROJECT_TEXT + projectIdentifier);
        } else {
            allExps.setBoxLabel(ALL_EXPERIMENTS_TEXT);
        }
        allExps.setBoxLabel(ALL_EXPERIMENTS_TEXT);
        experimentRadio.add(allExps);
        Radio oneExps = new Radio();
        oneExps.setBoxLabel(SINGLE_EXPERIMENT_TEXT);
        experimentRadio.add(oneExps);
        experimentRadio.setAutoHeight(true);
        experimentRadio.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                if (allExps.getValue().booleanValue()) {
                    singleExperimentChooser.getChooserField().setEnabled(false);
                    singleExperimentChooser.getChooserField().setEmptyText(SingleOrAllExperimentsChooser.ALL_EXPERIMENTS_TEXT);
                    SingleOrAllExperimentsChooser.this.experimentCriteriaHolder.setCriteria(WellSearchCriteria.ExperimentSearchCriteria.createAllExperiments());
                    SingleOrAllExperimentsChooser.this.refreshAction.execute();
                } else {
                    singleExperimentChooser.getChooserField().setEmptyText(SingleOrAllExperimentsChooser.CHOOSE_ONE_EXPERIMENT_TEXT);
                    singleExperimentChooser.getChooserField().setEnabled(true);
                    if (SingleOrAllExperimentsChooser.this.singleExperimentChooserStateOrNull == null) {
                        SingleOrAllExperimentsChooser.this.experimentCriteriaHolder.setCriteria(null);
                    } else {
                        SingleOrAllExperimentsChooser.this.experimentCriteriaHolder.setCriteria(WellSearchCriteria.ExperimentSearchCriteria.createExperiment(SingleOrAllExperimentsChooser.this.singleExperimentChooserStateOrNull, SingleOrAllExperimentsChooser.this.restrictGlobalScopeLinkToProject));
                        SingleOrAllExperimentsChooser.this.refreshAction.execute();
                    }
                }
            }
        });
        experimentRadio.setValue(this.isAllExperimentsChoosen() ? allExps : oneExps);
        return experimentRadio;
    }

    private void chooseSingleExperiment(ExperimentChooserField chooserField, Experiment experiment) {
        WellSearchCriteria.SingleExperimentSearchCriteria singleExperiment = new WellSearchCriteria.SingleExperimentSearchCriteria(experiment.getId(), experiment.getPermId(), experiment.getIdentifier());
        this.experimentCriteriaHolder.setCriteria(WellSearchCriteria.ExperimentSearchCriteria.createExperiment(singleExperiment, this.restrictGlobalScopeLinkToProject));
        this.updateSingleExperimentChooser(chooserField, singleExperiment);
    }

    private void updateSingleExperimentChooser(ExperimentChooserField chooserField, WellSearchCriteria.SingleExperimentSearchCriteria singleExperiment) {
        this.singleExperimentChooserStateOrNull = singleExperiment;
        chooserField.updateValue(new ExperimentIdentifier(singleExperiment.getExperimentIdentifier()));
        this.refreshAction.execute();
    }
}

