/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.RealField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.PlateLayouterModel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.IRangeType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.Range;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.RangeType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.NumberField;
import com.extjs.gxt.ui.client.widget.form.Validator;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HeatMapRangeChooser
extends Dialog {
    private final Map<CheckBoxField, RangeType> checkBoxToType = new HashMap<CheckBoxField, RangeType>();
    private final ScreeningViewContext viewContext;
    private Component checkedComponent;
    private FieldSet fieldSet;
    private NumberField fromField;
    private NumberField untilField;
    private FormPanel formPanel;

    HeatMapRangeChooser(ScreeningViewContext viewContext, PlateLayouterModel model, IDelegatedAction acceptAction) {
        this.viewContext = viewContext;
        this.setHeading(viewContext.getMessage("heat_map_range_chooser_title", new Object[0]));
        this.setWidth(500);
        this.setHeight(300);
        this.setButtons("");
        this.setScrollMode(Style.Scroll.AUTO);
        this.setHideOnButtonClick(true);
        this.setModal(true);
        this.createAndAddForm();
        this.addButtons(model, acceptAction);
        this.initComponents(model.getRangeType());
    }

    private void createAndAddForm() {
        RangeType[] values;
        this.formPanel = new FormPanel();
        this.formPanel.setLabelWidth(200);
        this.formPanel.setBodyBorder(false);
        this.formPanel.setHeaderVisible(false);
        this.formPanel.add((Widget)new Label("Choose one of range types:"));
        this.formPanel.add((Widget)new Label());
        RangeType[] rangeTypeArray = values = RangeType.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            RangeType rangeType = rangeTypeArray[n2];
            CheckBoxField checkBoxField = new CheckBoxField(this.viewContext.getMessage("heat_map_range_chooser_type_label_" + rangeType, new Object[0]), false);
            checkBoxField.setToolTip(this.viewContext.getMessage("heat_map_range_chooser_type_tooltip_" + rangeType, new Object[0]));
            this.addListenerTo(checkBoxField);
            this.formPanel.add((Widget)checkBoxField);
            this.checkBoxToType.put(checkBoxField, rangeType);
            ++n2;
        }
        this.createAndAddFieldSetForFixedType();
        this.add((Widget)this.formPanel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
    }

    private void createAndAddFieldSetForFixedType() {
        this.fieldSet = new FieldSet();
        this.fieldSet.setHeading(this.viewContext.getMessage("heat_map_range_chooser_type_fixed_type_label", new Object[0]));
        this.fieldSet.setCheckboxToggle(true);
        FormLayout layout = new FormLayout();
        layout.setLabelWidth(190);
        this.fieldSet.setLayout((Layout)layout);
        this.fieldSet.collapse();
        this.addListenerTo(this.fieldSet);
        Validator validator = this.createValidatorForFixedTypeFields();
        this.fromField = this.createNumberField("heat_map_range_chooser_type_fixed_type_lowest_scale_label", validator);
        this.untilField = this.createNumberField("heat_map_range_chooser_type_fixed_type_highest_scale_label", validator);
        this.fieldSet.add((Widget)this.untilField);
        this.fieldSet.add((Widget)this.fromField);
        this.formPanel.add((Widget)this.fieldSet);
    }

    private NumberField createNumberField(String labelKey, Validator validator) {
        RealField field = new RealField(this.viewContext.getMessage(labelKey, new Object[0]), false){

            protected boolean validateValue(String fieldValue) {
                String msg;
                if (this.validator != null && (msg = this.validator.validate((Field)this, fieldValue)) != null) {
                    this.markInvalid(msg);
                    return false;
                }
                return super.validateValue(fieldValue);
            }
        };
        field.setValidator(validator);
        return field;
    }

    private Validator createValidatorForFixedTypeFields() {
        Validator validator = new Validator(){

            public String validate(Field<?> field, String value) {
                if (HeatMapRangeChooser.this.fieldSet.isExpanded()) {
                    if (value == null || value.isEmpty()) {
                        return "Unspecified value";
                    }
                    Number fromValue = (Number)HeatMapRangeChooser.this.fromField.getValue();
                    Number untilValue = (Number)HeatMapRangeChooser.this.untilField.getValue();
                    if (fromValue != null && untilValue != null && fromValue.doubleValue() == untilValue.doubleValue()) {
                        return HeatMapRangeChooser.this.viewContext.getMessage("heat_map_range_chooser_type_fixed_type_same_value_validation_message", new Object[0]);
                    }
                }
                return null;
            }
        };
        return validator;
    }

    private void addButtons(final PlateLayouterModel model, final IDelegatedAction acceptAction) {
        this.addButton(new Button("OK", (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                if (HeatMapRangeChooser.this.formPanel.isValid()) {
                    IRangeType rangeType = HeatMapRangeChooser.this.getRangeType();
                    if (rangeType != null) {
                        model.setRangeType(rangeType);
                        acceptAction.execute();
                    }
                    HeatMapRangeChooser.this.hide();
                }
            }
        }));
        this.addButton(new Button(this.viewContext.getMessage("button_cancel", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                HeatMapRangeChooser.this.hide();
            }
        }));
    }

    private void initComponents(IRangeType rangeType) {
        Set<Map.Entry<CheckBoxField, RangeType>> entrySet = this.checkBoxToType.entrySet();
        for (Map.Entry<CheckBoxField, RangeType> entry : entrySet) {
            if (!entry.getValue().equals(rangeType)) continue;
            CheckBoxField checkBox = entry.getKey();
            checkBox.setValue(true);
            this.checkedComponent = checkBox;
            return;
        }
        if (rangeType instanceof Range) {
            Range range = (Range)rangeType;
            this.fieldSet.expand();
            this.fromField.setValue((Object)Float.valueOf(range.getFrom()));
            this.untilField.setValue((Object)Float.valueOf(range.getUntil()));
            this.checkedComponent = this.fieldSet;
        }
    }

    private void addListenerTo(final CheckBox checkBox) {
        checkBox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                HeatMapRangeChooser.this.buttonPressed((Component)checkBox);
            }
        });
    }

    private void addListenerTo(final FieldSet fSet) {
        fSet.addListener(Events.Expand, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                HeatMapRangeChooser.this.buttonPressed((Component)fSet);
            }
        });
    }

    private void buttonPressed(Component component) {
        if (component == this.checkedComponent) {
            return;
        }
        if (this.checkedComponent != null) {
            if (this.checkedComponent instanceof CheckBox) {
                CheckBox checkBox = (CheckBox)this.checkedComponent;
                checkBox.setValue(Boolean.valueOf(false));
            } else if (this.checkedComponent instanceof FieldSet) {
                FieldSet fSet = (FieldSet)this.checkedComponent;
                fSet.collapse();
            }
        }
        this.checkedComponent = component;
    }

    private IRangeType getRangeType() {
        if (this.checkedComponent == null) {
            return null;
        }
        if (this.checkedComponent == this.fieldSet) {
            return new Range(((Number)this.fromField.getValue()).floatValue(), ((Number)this.untilField.getValue()).floatValue());
        }
        return this.checkBoxToType.get(this.checkedComponent);
    }
}

