/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.dto.Color;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.dto.HeatmapScaleElement;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

class HeatmapScaleFactory {
    HeatmapScaleFactory() {
    }

    public static Component create(String firstLabelOrNull, List<HeatmapScaleElement> scaleElements) {
        boolean isFirstLabel;
        LayoutContainer container = new LayoutContainer();
        container.setLayout((Layout)new TableLayout(2));
        container.setBorders(false);
        container.setScrollMode(Style.Scroll.NONE);
        container.setAutoHeight(true);
        boolean bl = isFirstLabel = firstLabelOrNull != null;
        if (isFirstLabel) {
            container.add((Widget)HeatmapScaleFactory.createLabel(isFirstLabel, firstLabelOrNull), (LayoutData)HeatmapScaleFactory.createLabelData(isFirstLabel));
            container.add((Widget)HeatmapScaleFactory.createBox(null), (LayoutData)HeatmapScaleFactory.createBoxData());
        }
        for (HeatmapScaleElement r : scaleElements) {
            container.add((Widget)HeatmapScaleFactory.createLabel(isFirstLabel, r.getLabel()), (LayoutData)HeatmapScaleFactory.createLabelData(isFirstLabel));
            container.add((Widget)HeatmapScaleFactory.createBox(r.getColor()), (LayoutData)HeatmapScaleFactory.createBoxData());
        }
        if (isFirstLabel) {
            container.add((Widget)HeatmapScaleFactory.createLabel(isFirstLabel, ""), (LayoutData)HeatmapScaleFactory.createLabelData(isFirstLabel));
            container.add((Widget)HeatmapScaleFactory.createBox(null), (LayoutData)HeatmapScaleFactory.createBoxData());
        }
        return container;
    }

    private static TableData createBoxData() {
        return new TableData(Style.HorizontalAlignment.LEFT, Style.VerticalAlignment.TOP);
    }

    private static TableData createLabelData(boolean isFirstLabel) {
        if (isFirstLabel) {
            return new TableData(Style.HorizontalAlignment.RIGHT, Style.VerticalAlignment.BOTTOM);
        }
        return new TableData(Style.HorizontalAlignment.RIGHT, Style.VerticalAlignment.MIDDLE);
    }

    private static Component createBox(Color color) {
        Text box = new Text();
        box.setStyleAttribute("margin-left", "0.5em");
        if (color != null) {
            box.setStyleAttribute("background-color", color.getHexColor());
        }
        int size = 22;
        box.setWidth("" + size);
        box.setHeight("" + size);
        return box;
    }

    private static Component createLabel(boolean isFirstLabel, String text) {
        Text label = new Text(text);
        label.setStyleAttribute("font-size", "0.75em");
        label.setStyleAttribute("position", "relative");
        if (isFirstLabel) {
            label.setStyleAttribute("bottom", "-0.6em");
        }
        return label;
    }
}

