/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.IRealNumberRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.RealNumberRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleModelComboBox;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.ToolTipAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.PlateStyleSetter;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.WellContentDialog;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.WellData;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.HeatmapPresenter;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.LayoutUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.dto.Color;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.PlateLayouterModel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.utils.GuiUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.PlateUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureList;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateImages;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateMetadata;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.extjs.gxt.ui.client.widget.tips.ToolTip;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlateLayouter {
    private static final String HEATMAP_KIND_CHOOSER_LABEL_MSG = "Choose heatmap kind:";
    private static final String FEATURE_LISTS_LABEL_MSG = "Choose features list:";
    private static final String METADATA_HEATMAP_KIND_MSG = "Metadata";
    private static final String FEATURE_HEATMAP_KIND_PREFIX_MSG = "Feature ";
    private static final int HEATMAP_KIND_COMBOBOX_CHOOSER_WIDTH_PX = 200;
    private final PlateLayouterModel model;
    private final HeatmapPresenter presenter;
    private final Widget view;
    private final SimpleModelComboBox<CodeAndLabel> heatmapKindChooser;
    private final Component[][] renderedWells;
    private SimpleModelComboBox<FeatureList> featureListsSelector;
    private final HashMap<String, FeatureVectorDataset> featureVectorDatasetCache;

    public static Widget createVisualization(PlateImages plateImages, ScreeningViewContext viewContext) {
        PlateLayouter plateLayouter = new PlateLayouter(viewContext, plateImages.getPlateMetadata());
        ImageDatasetEnrichedReference imageDataset = new ImageDatasetEnrichedReference(plateImages.getImagesDataset());
        plateLayouter.changeDisplayedImageDataset(imageDataset);
        return plateLayouter.getView();
    }

    public PlateLayouter(ScreeningViewContext viewContext, PlateMetadata plateMetadata) {
        this.model = new PlateLayouterModel(plateMetadata, viewContext.getTechnologySpecificDisplaySettingsManager());
        this.renderedWells = PlateLayouter.renderWells(this.model, viewContext, this);
        LayoutContainer legendContainer = new LayoutContainer();
        IRealNumberRenderer realNumberRenderer = this.createRealNumberRenderer(viewContext);
        this.presenter = new HeatmapPresenter(viewContext, this.model, realNumberRenderer, this.createViewManipulator(viewContext, legendContainer));
        this.heatmapKindChooser = PlateLayouter.createHeatmapKindComboBox(this.presenter, viewContext);
        this.featureListsSelector = new SimpleModelComboBox(viewContext, PlateLayouter.createFeaturesListsModel(null), 200);
        this.featureListsSelector.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SimpleComboValue<LabeledItem<FeatureList>>>(){

            public void selectionChanged(SelectionChangedEvent<SimpleComboValue<LabeledItem<FeatureList>>> se) {
                FeatureList featureList = SimpleModelComboBox.getChosenItem(se);
                if (featureList == null) {
                    PlateLayouter.updateHeatmapKindComboBox(PlateLayouter.this.heatmapKindChooser, PlateLayouter.this.model.getAllFeatureNames());
                } else {
                    PlateLayouter.updateHeatmapKindComboBox(PlateLayouter.this.heatmapKindChooser, PlateLayouter.this.labelsOfFeatureList(featureList));
                }
            }
        });
        this.featureVectorDatasetCache = new HashMap();
        this.view = PlateLayouter.renderView(this.renderedWells, this.heatmapKindChooser, this.featureListsSelector, legendContainer);
    }

    private IRealNumberRenderer createRealNumberRenderer(ScreeningViewContext viewContext) {
        return new RealNumberRenderer(viewContext.getDisplaySettingsManager().getRealNumberFormatingParameters());
    }

    private HeatmapPresenter.IHeatmapViewManipulator createViewManipulator(ScreeningViewContext viewContext, final LayoutContainer legendContainer) {
        return new HeatmapPresenter.IHeatmapViewManipulator(){
            private Map<Component, ToolTipAction> toolTipActions = new HashMap<Component, ToolTipAction>();

            @Override
            public void updateWellStyle(int rowIx, int colIx, Color backgroundColor) {
                Component wellComponent = this.getWellComponent(rowIx, colIx);
                PlateStyleSetter.setBackgroudColor(wellComponent, backgroundColor.getHexColor());
            }

            @Override
            public void addEmptyTooltip(int rowIx, int colIx) {
                Component wellComponent = this.getWellComponent(rowIx, colIx);
                String anchor = colIx < PlateLayouter.this.renderedWells[0].length / 2 ? "left" : "right";
                ToolTipConfig config = new ToolTipConfig("Loading...");
                config.setMouseOffset(new int[2]);
                config.setAnchor(anchor);
                config.setDismissDelay(10000);
                GWTUtils.setToolTip(wellComponent, config);
            }

            @Override
            public void updateTooltip(int rowIx, int colIx, String tooltipOrNull) {
                this.hideAllToolTipsExcept(rowIx, colIx);
                Component wellComponent = this.getWellComponent(rowIx, colIx);
                if (tooltipOrNull != null) {
                    String preparedText = GWTUtils.translateToHtmlLineBreaks(tooltipOrNull);
                    wellComponent.setToolTip(preparedText);
                } else {
                    wellComponent.hideToolTip();
                }
            }

            @Override
            public void scheduleUpdateTooltip(int rowIx, int colIx, IDelegatedAction refreshTooltipAction) {
                Component wellComponent = this.getWellComponent(rowIx, colIx);
                ToolTipAction toolTipAction = this.toolTipActions.get(wellComponent);
                if (toolTipAction == null) {
                    toolTipAction = new ToolTipAction(wellComponent);
                    toolTipAction.setAction(refreshTooltipAction);
                    this.toolTipActions.put(wellComponent, toolTipAction);
                } else {
                    toolTipAction.setAction(refreshTooltipAction);
                }
            }

            @Override
            public void updateLegend(Widget legend) {
                legendContainer.removeAll();
                legendContainer.add(legend);
                legendContainer.setAutoHeight(true);
                legendContainer.layout();
            }

            private Component getWellComponent(int rowIx, int colIx) {
                Component wellComponent = PlateLayouter.this.renderedWells[rowIx][colIx];
                return wellComponent;
            }

            private void hideAllToolTipsExcept(int rowIx, int colIx) {
                int row = 0;
                while (row < PlateLayouter.this.renderedWells.length) {
                    int col = 0;
                    while (col < PlateLayouter.this.renderedWells[row].length) {
                        if (row != rowIx || col != colIx) {
                            PlateLayouter.this.renderedWells[row][col].hideToolTip();
                        }
                        ++col;
                    }
                    ++row;
                }
            }
        };
    }

    public Widget getView() {
        return this.view;
    }

    public void changeDisplayedImageDataset(ImageDatasetEnrichedReference newImageDatasetOrNull) {
        this.model.setImageDataset(newImageDatasetOrNull);
    }

    public void changeDisplayedFeatureVectorDataset(ScreeningViewContext context, DatasetReference reference) {
        String dataSetCode = reference.getCode();
        if (this.featureVectorDatasetCache.containsKey(dataSetCode)) {
            this.changeDisplayedFeatureVectorDataset(this.featureVectorDatasetCache.get(dataSetCode));
        } else {
            ((IScreeningClientServiceAsync)context.getService()).getFeatureVectorDataset(reference, null, this.createLoadFeatureCallback(context, dataSetCode));
        }
    }

    private AsyncCallback<FeatureVectorDataset> createLoadFeatureCallback(ScreeningViewContext context, final String code) {
        return new AbstractAsyncCallback<FeatureVectorDataset>((IViewContext)context){

            @Override
            protected void process(FeatureVectorDataset featureVector) {
                PlateLayouter.this.featureVectorDatasetCache.put(code, featureVector);
                PlateLayouter.this.changeDisplayedFeatureVectorDataset(featureVector);
            }
        };
    }

    public void changeDisplayedFeatureVectorDataset(FeatureVectorDataset dataset) {
        this.model.setFeatureVectorDataset(dataset);
        PlateLayouter.updateFeaturesListsComboBox(this.featureListsSelector, this.model.getFeatureLists());
        PlateLayouter.updateHeatmapKindComboBox(this.heatmapKindChooser, this.labelsOfFeatureList((FeatureList)((LabeledItem)((SimpleComboValue)this.featureListsSelector.getValue()).getValue()).getItem()));
    }

    private List<CodeAndLabel> labelsOfFeatureList(FeatureList featureList) {
        HashMap<String, CodeAndLabel> map = new HashMap<String, CodeAndLabel>();
        for (CodeAndLabel codeAndLabel : this.model.getAllFeatureNames()) {
            map.put(codeAndLabel.getLabel(), codeAndLabel);
        }
        ArrayList<CodeAndLabel> result = new ArrayList<CodeAndLabel>();
        for (String feature : featureList.getFeatures()) {
            if (!map.containsKey(feature)) continue;
            result.add((CodeAndLabel)map.get(feature));
        }
        return result;
    }

    private static Widget renderView(Component[][] renderedWells, SimpleModelComboBox<CodeAndLabel> heatmapKindChooser, SimpleModelComboBox<FeatureList> featureListsSelector, LayoutContainer legendContainer) {
        LayoutContainer container = new LayoutContainer();
        container.setScrollMode(Style.Scroll.AUTO);
        container.setLayout((Layout)new RowLayout());
        container.add((Widget)new Text("Hold the mouse cursor over a well or click on it to get the details."), (LayoutData)LayoutUtils.createRowLayoutHorizontalMargin());
        container.add((Widget)GuiUtils.renderInRow(new Widget[]{new Text(HEATMAP_KIND_CHOOSER_LABEL_MSG), heatmapKindChooser, new Text(FEATURE_LISTS_LABEL_MSG), featureListsSelector}));
        LayoutContainer plateContainer = new LayoutContainer();
        plateContainer.setLayout((Layout)new ColumnLayout());
        int legendWidth = 200;
        int plateWidth = PlateLayouter.getPlateMatrixPixelWidth(renderedWells);
        int totalWidth = plateWidth + legendWidth;
        plateContainer.setAutoHeight(true);
        plateContainer.setWidth(totalWidth);
        plateContainer.add((Widget)PlateLayouter.renderPlateLayout(renderedWells));
        Component separator = PlateLayouter.createBox();
        separator.setPixelSize(20, 20);
        plateContainer.add((Widget)separator);
        plateContainer.add((Widget)legendContainer);
        container.add((Widget)plateContainer);
        container.setAutoHeight(true);
        container.setWidth(totalWidth);
        return container;
    }

    private static int getPlateMatrixPixelHeight(Component[][] renderedWells) {
        return PlateLayouter.getPlateMatrixPixelHeight(renderedWells.length + 1);
    }

    private static int getPlateMatrixPixelHeight(int numRows) {
        return 2 * (numRows + 1) + 20 * numRows;
    }

    private static int getPlateMatrixPixelWidth(Component[][] renderedWells) {
        int boxes = PlateLayouter.getColumnsNum(renderedWells) + 1;
        return Math.max(680, 2 * (boxes + 1) + 20 * boxes);
    }

    private static LayoutContainer renderPlateLayout(Component[][] renderedWells) {
        LayoutContainer plateMatrix = new LayoutContainer();
        int columnsNum = PlateLayouter.getColumnsNum(renderedWells) + 1;
        TableLayout layout = new TableLayout(columnsNum);
        layout.setCellSpacing(2);
        plateMatrix.setLayout((Layout)layout);
        plateMatrix.setAutoWidth(true);
        int height = PlateLayouter.getPlateMatrixPixelHeight(renderedWells);
        plateMatrix.setHeight(height);
        PlateLayouter.addPlateWidgets(plateMatrix, renderedWells);
        return plateMatrix;
    }

    private static Component[][] renderWells(PlateLayouterModel model, ScreeningViewContext viewContext, PlateLayouter layouter) {
        WellData[][] wellMatrix = model.getWellMatrix();
        int rowsNum = wellMatrix.length;
        int colsNum = PlateLayouter.getColumnsNum(wellMatrix);
        Component[][] wells = new Component[rowsNum][colsNum];
        int row = 0;
        while (row < rowsNum) {
            int col = 0;
            while (col < colsNum) {
                WellData wellData = wellMatrix[row][col];
                wells[row][col] = PlateLayouter.createWellWidget(wellData, model, viewContext, layouter);
                ++col;
            }
            ++row;
        }
        return wells;
    }

    private static void addPlateWidgets(LayoutContainer plateTable, Component[][] wellMatrix) {
        int rowsNum = wellMatrix.length;
        int colsNum = PlateLayouter.getColumnsNum(wellMatrix);
        int row = 0;
        while (row <= rowsNum) {
            int col = 0;
            while (col <= colsNum) {
                if (row != 0 && col != 0) {
                    plateTable.add((Widget)wellMatrix[row - 1][col - 1]);
                } else {
                    Component labelWidget = PlateLayouter.tryCreateLabelWidget(row, col);
                    assert (labelWidget != null) : "Label widget is null";
                    plateTable.add((Widget)labelWidget);
                }
                ++col;
            }
            ++row;
        }
    }

    private static Component createWellBox(WellData wellData) {
        Component widget = PlateLayouter.createBox();
        return PlateStyleSetter.setWellStyle(widget);
    }

    private static <T> int getColumnsNum(T[][] matrix) {
        int rowsNum = matrix.length;
        return rowsNum == 0 ? 0 : matrix[0].length;
    }

    private static Component tryCreateLabelWidget(int row, int col) {
        String text = null;
        if (row == 0) {
            text = col == 0 ? "" : "" + col;
        } else if (col == 0) {
            text = PlateUtils.translateRowNumberIntoLetterCode(row);
        }
        if (text != null) {
            Text widget = new Text(text);
            return PlateStyleSetter.setWellLabelStyle((Component)widget);
        }
        return null;
    }

    private static Component createWellWidget(final WellData wellData, final PlateLayouterModel model, final ScreeningViewContext screeningViewContext, PlateLayouter layouter) {
        Component widget = PlateLayouter.createWellBox(wellData);
        widget.addListener(Events.OnMouseDown, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent ce) {
                PlateLayouter.this.hideAllTooltops();
                IScreeningClientServiceAsync service = (IScreeningClientServiceAsync)screeningViewContext.getService();
                ImageDatasetEnrichedReference dataset = model.tryGetImageDataset();
                if (dataset == null) {
                    WellContentDialog.showContentDialog(wellData, model.getPlateSample(), null, screeningViewContext);
                } else {
                    DatasetImagesReference imageDataset = dataset.getImageDataset();
                    service.getImageDatasetReference(imageDataset.getDatasetCode(), imageDataset.getDatastoreCode(), (AsyncCallback<ImageDatasetEnrichedReference>)new AbstractAsyncCallback<ImageDatasetEnrichedReference>((IViewContext)screeningViewContext){

                        @Override
                        protected void process(ImageDatasetEnrichedReference refreshedDataset) {
                            model.setImageDataset(refreshedDataset);
                            WellContentDialog.showContentDialog(wellData, PlateLayouter.this.model.getPlateSample(), refreshedDataset, screeningViewContext);
                        }
                    });
                }
            }
        });
        widget.sinkEvents(Events.OnMouseDown.getEventCode());
        return widget;
    }

    private void hideAllTooltops() {
        int row = 0;
        while (row < this.renderedWells.length) {
            int col = 0;
            while (col < this.renderedWells[row].length) {
                this.renderedWells[row][col].hideToolTip();
                ++col;
            }
            ++row;
        }
    }

    private static Component createBox() {
        return new Text(""){

            public void setToolTip(ToolTipConfig config) {
                if (config != null && this.toolTip == null) {
                    this.toolTip = new ToolTip((Component)this, config){

                        public void update(ToolTipConfig tooTipConfig) {
                            super.update(tooTipConfig);
                            if (this.isRendered() && this.isAttached()) {
                                this.hide();
                                this.doAutoWidth();
                                this.show();
                            }
                        }
                    };
                }
                super.setToolTip(config);
            }
        };
    }

    private static SimpleModelComboBox<CodeAndLabel> createHeatmapKindComboBox(final HeatmapPresenter presenter, IMessageProvider messageProvider) {
        List items = PlateLayouter.createHeatmapKindModel(null);
        SimpleModelComboBox<CodeAndLabel> chooser = new SimpleModelComboBox<CodeAndLabel>(messageProvider, items, 200);
        chooser.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SimpleComboValue<LabeledItem<CodeAndLabel>>>(){

            public void selectionChanged(SelectionChangedEvent<SimpleComboValue<LabeledItem<CodeAndLabel>>> se) {
                CodeAndLabel featureName = SimpleModelComboBox.getChosenItem(se);
                if (featureName == null) {
                    presenter.setWellMetadataMode();
                } else {
                    presenter.setFeatureValueMode(featureName);
                }
            }
        });
        return chooser;
    }

    private static void updateHeatmapKindComboBox(SimpleModelComboBox<CodeAndLabel> chooser, List<CodeAndLabel> featureNames) {
        List items = PlateLayouter.createHeatmapKindModel(featureNames);
        chooser.removeAll();
        chooser.add(items);
        GWTUtils.autoselect(chooser, false);
    }

    private static List<LabeledItem<CodeAndLabel>> createHeatmapKindModel(List<CodeAndLabel> featureNamesOrNull) {
        ArrayList<LabeledItem<CodeAndLabel>> items = new ArrayList<LabeledItem<CodeAndLabel>>();
        items.add(new LabeledItem<Object>(null, METADATA_HEATMAP_KIND_MSG));
        if (featureNamesOrNull != null) {
            for (CodeAndLabel featureName : featureNamesOrNull) {
                String label = FEATURE_HEATMAP_KIND_PREFIX_MSG + featureName.getLabel();
                items.add(new LabeledItem<CodeAndLabel>(featureName, label));
            }
        }
        return items;
    }

    private static void updateFeaturesListsComboBox(SimpleModelComboBox<FeatureList> chooser, List<FeatureList> featureLists) {
        List items = PlateLayouter.createFeaturesListsModel(featureLists);
        chooser.removeAll();
        chooser.add(items);
        GWTUtils.autoselect(chooser, false);
    }

    private static List<LabeledItem<FeatureList>> createFeaturesListsModel(List<FeatureList> featureListsOrNull) {
        ArrayList<LabeledItem<FeatureList>> items = new ArrayList<LabeledItem<FeatureList>>();
        items.add(new LabeledItem<Object>(null, "All"));
        if (featureListsOrNull != null) {
            for (FeatureList featureList : featureListsOrNull) {
                String label = featureList.getName();
                items.add(new LabeledItem<FeatureList>(featureList, label));
            }
        }
        return items;
    }
}

