/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.ColorConstants;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.IHeatmapRenderer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.dto.Color;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.dto.HeatmapScaleElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class StringHeatmapRenderer
implements IHeatmapRenderer<String> {
    private static final String CATEGORY_OTHERS_LABEL = "Others";
    private final List<HeatmapScaleElement> scale;
    private final Map<String, Color> colorsMap;
    private final boolean moreLabelsThanColors;

    public StringHeatmapRenderer(List<String> values) {
        this(values, null);
    }

    private static List<Color> getDefaultColors(int size) {
        List<String> colors = size <= ColorConstants.SHORT_DEFAULT_COLORS.size() ? ColorConstants.SHORT_DEFAULT_COLORS : ColorConstants.LONG_GRADIENT_DEFAULT_COLORS;
        return ColorConstants.asColors(colors);
    }

    public StringHeatmapRenderer(List<String> uniqueValues, List<Color> scaleColorsOrNull) {
        List<Color> scaleColors = scaleColorsOrNull != null ? scaleColorsOrNull : StringHeatmapRenderer.getDefaultColors(uniqueValues.size());
        this.scale = StringHeatmapRenderer.calculateScale(uniqueValues, scaleColors);
        this.colorsMap = StringHeatmapRenderer.calculateColorMap(this.scale);
        boolean bl = this.moreLabelsThanColors = uniqueValues.size() > scaleColors.size();
        if (this.moreLabelsThanColors) {
            this.scale.add(new HeatmapScaleElement(CATEGORY_OTHERS_LABEL, ColorConstants.CATEGORY_OTHERS_COLOR));
        }
    }

    private static Map<String, Color> calculateColorMap(List<HeatmapScaleElement> scale) {
        HashMap<String, Color> colorsMap = new HashMap<String, Color>();
        for (HeatmapScaleElement range : scale) {
            colorsMap.put(range.getLabel(), range.getColor());
        }
        return colorsMap;
    }

    private static List<HeatmapScaleElement> calculateScale(List<String> uniqueValues, List<Color> scaleColors) {
        ArrayList<HeatmapScaleElement> scale = new ArrayList<HeatmapScaleElement>();
        Iterator<Color> colorsIter = scaleColors.iterator();
        Iterator<String> valuesIter = uniqueValues.iterator();
        while (colorsIter.hasNext() && valuesIter.hasNext()) {
            scale.add(new HeatmapScaleElement(valuesIter.next(), colorsIter.next()));
        }
        return scale;
    }

    @Override
    public Color getColor(String value) {
        Color color = this.colorsMap.get(value);
        if (color == null) {
            return ColorConstants.CATEGORY_OTHERS_COLOR;
        }
        return color;
    }

    @Override
    public List<HeatmapScaleElement> calculateScale() {
        return this.scale;
    }

    @Override
    public String tryGetFirstLabel() {
        return null;
    }
}

