/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.IRangeCalculator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.MinMaxRangeCalculator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.PercentileRangeCalculator;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.IRangeType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.Range;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.RangeType;
import java.util.List;

class RangeCalculatorFactory {
    RangeCalculatorFactory() {
    }

    static IRangeCalculator create(IRangeType rangeType) {
        if (rangeType instanceof Range) {
            final Range range = (Range)rangeType;
            return new IRangeCalculator(){

                @Override
                public Range calculate(List<Float> numbers) {
                    return range;
                }
            };
        }
        if (rangeType instanceof RangeType) {
            RangeType type = (RangeType)rangeType;
            switch (type) {
                case MIN_MAX: {
                    return new MinMaxRangeCalculator();
                }
                case PERCENTILE_10_90: {
                    return new PercentileRangeCalculator(10, 90);
                }
            }
        }
        throw new IllegalArgumentException("Unknown range type: " + rangeType);
    }
}

