/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage.LogicalImageSeriesPoint;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageChannelStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class LogicalImageSeriesModel {
    private final Map<LogicalImageSeriesPoint, List<ImageChannelStack>> channelStackImagesBySeries = new TreeMap<LogicalImageSeriesPoint, List<ImageChannelStack>>();
    private final List<LogicalImageSeriesPoint> sortedPoints;
    private final int numberOfTimepoints;
    private final int numberOfDepthLevels;
    private final boolean matrixViewPossible;
    private List<List<LogicalImageSeriesPoint>> matrix;

    public LogicalImageSeriesModel(List<ImageChannelStack> channelStackImages) {
        TreeMap<Float, TreeMap<Float, LogicalImageSeriesPoint>> timePointDepthMatrix = new TreeMap<Float, TreeMap<Float, LogicalImageSeriesPoint>>();
        boolean seriesNumberPresent = false;
        boolean timepointOrDepthNotPresent = false;
        for (ImageChannelStack ref : channelStackImages) {
            LogicalImageSeriesPoint point = new LogicalImageSeriesPoint(ref);
            List<ImageChannelStack> imageReferences = this.channelStackImagesBySeries.get(point);
            if (imageReferences == null) {
                imageReferences = new ArrayList<ImageChannelStack>();
                this.channelStackImagesBySeries.put(point, imageReferences);
            }
            imageReferences.add(ref);
            Integer seriesNumberOrNull = ref.tryGetSeriesNumber();
            if (seriesNumberOrNull != null) {
                seriesNumberPresent = true;
            }
            Float timepoint = ref.tryGetTimepoint();
            Float depth = ref.tryGetDepth();
            if (timepoint == null || depth == null) {
                timepointOrDepthNotPresent = true;
                continue;
            }
            TreeMap<Float, LogicalImageSeriesPoint> depthMap = (TreeMap<Float, LogicalImageSeriesPoint>)timePointDepthMatrix.get(timepoint);
            if (depthMap == null) {
                depthMap = new TreeMap<Float, LogicalImageSeriesPoint>();
                timePointDepthMatrix.put(timepoint, depthMap);
            }
            depthMap.put(depth, point);
        }
        this.sortedPoints = new ArrayList<LogicalImageSeriesPoint>(this.channelStackImagesBySeries.keySet());
        Collections.sort(this.sortedPoints);
        this.numberOfTimepoints = timePointDepthMatrix.size();
        Collection values = timePointDepthMatrix.values();
        this.matrix = new ArrayList<List<LogicalImageSeriesPoint>>();
        HashSet<Integer> depthMapSizes = new HashSet<Integer>();
        int depthLevelCount = 0;
        for (Map depthMap : values) {
            this.matrix.add(new ArrayList(depthMap.values()));
            depthLevelCount = Math.max(depthLevelCount, depthMap.size());
            depthMapSizes.add(depthMap.size());
        }
        this.numberOfDepthLevels = depthLevelCount;
        this.matrixViewPossible = !seriesNumberPresent && !timepointOrDepthNotPresent && depthMapSizes.size() == 1;
    }

    public LogicalImageSeriesPoint get(int timeIndex, int depthIndex) {
        return this.matrix.get(timeIndex).get(depthIndex);
    }

    public final int getNumberOfTimepoints() {
        return this.numberOfTimepoints;
    }

    public final int getNumberOfDepthLevels() {
        return this.numberOfDepthLevels;
    }

    public final boolean isMatrixViewPossible() {
        return this.matrixViewPossible;
    }

    public List<LogicalImageSeriesPoint> getSortedPoints() {
        return this.sortedPoints;
    }

    public List<List<ImageChannelStack>> getSortedChannelStackSeriesPoints() {
        ArrayList<List<ImageChannelStack>> sortedSeries = new ArrayList<List<ImageChannelStack>>();
        for (LogicalImageSeriesPoint point : this.sortedPoints) {
            List<ImageChannelStack> series = this.channelStackImagesBySeries.get(point);
            sortedSeries.add(series);
        }
        return sortedSeries;
    }
}

