/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AbstractColumnExtractor {
    private final Map<String, Integer> columnIndices;
    private final Map<String, Integer> unknownColumnIndices;

    public AbstractColumnExtractor(String[] headerTokens, String[] expectedColumnNames) {
        this.columnIndices = AbstractColumnExtractor.createColumnIndex(headerTokens, expectedColumnNames);
        this.unknownColumnIndices = AbstractColumnExtractor.getOmittedIndices(this.columnIndices, headerTokens);
    }

    public List<String> getUnknownColumnNames() {
        return new ArrayList<String>(this.unknownColumnIndices.keySet());
    }

    private static Map<String, Integer> getOmittedIndices(Map<String, Integer> columnIndex, String[] headers) {
        HashMap<String, Integer> omittedIndices = new HashMap<String, Integer>();
        HashSet<Integer> knownIndices = new HashSet<Integer>(columnIndex.values());
        int i = 0;
        while (i < headers.length) {
            if (!knownIndices.contains(i)) {
                omittedIndices.put(headers[i], i);
            }
            ++i;
        }
        return omittedIndices;
    }

    private static Map<String, Integer> createColumnIndex(String[] headers, String[] expectedColumnNames) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] stringArray = expectedColumnNames;
        int n = expectedColumnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            AbstractColumnExtractor.findAndPut(map, headers, columnName);
            ++n2;
        }
        return map;
    }

    private static void findAndPut(Map<String, Integer> map, String[] headers, String columnName) {
        int ix = AbstractColumnExtractor.findIndexOrDie(headers, columnName);
        map.put(columnName, ix);
    }

    private static int findIndexOrDie(String[] headers, String columnName) {
        int i = 0;
        while (i < headers.length) {
            if (headers[i].equalsIgnoreCase(columnName)) {
                return i;
            }
            ++i;
        }
        throw new UserFailureException("Column " + columnName + " does not exist in " + CollectionUtils.abbreviate(headers, -1));
    }

    protected String getValue(String[] row, String columnName) {
        Integer ix = this.columnIndices.get(columnName);
        return AbstractColumnExtractor.valueAt(row, ix);
    }

    private static String valueAt(String[] row, Integer ix) {
        if (ix >= row.length) {
            return "";
        }
        return row[ix];
    }

    private String asCode(String value) {
        String code = "";
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (!this.isValidCodeCharacter(ch)) {
                ch = '_';
            }
            code = String.valueOf(code) + ch;
            ++i;
        }
        return code;
    }

    private boolean isValidCodeCharacter(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_';
    }

    protected String getCodeValue(String[] row, String columnName) {
        return this.asCode(this.getValue(row, columnName));
    }

    public List<String> getUnknownColumnValues(String[] row, List<String> columnNames) {
        ArrayList<String> values = new ArrayList<String>();
        for (String columnName : columnNames) {
            Integer ix = this.unknownColumnIndices.get(columnName);
            String value = AbstractColumnExtractor.valueAt(row, ix);
            values.add(value);
        }
        return values;
    }
}

