/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.AbstractColumnExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.PlateWellLocation;

public class PlateImageAnalysisColumnExtractor
extends AbstractColumnExtractor {
    private static final String PLATE_NAME = "barcode";
    private static final String WELL_ROW = "row";
    private static final String WELL_COL = "col";
    private static final String[] EXPECTED_COLUMNS = new String[]{"barcode", "row", "col"};

    public PlateImageAnalysisColumnExtractor(String[] headerTokens) {
        super(headerTokens, EXPECTED_COLUMNS);
    }

    private String getPlateCode(String[] row) {
        return this.getCodeValue(row, PLATE_NAME);
    }

    private String getWellCol(String[] row) {
        return this.getValue(row, WELL_COL);
    }

    private String getWellRow(String[] row) {
        return this.getValue(row, WELL_ROW);
    }

    public PlateWellLocation getPlateWellLocation(String[] row) {
        return new PlateWellLocation(this.getPlateCode(row), this.getWellRow(row), this.getWellCol(row));
    }
}

