/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.screening.shared.IScreeningServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSimpleFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.util.List;

public class MaterialFeatureVectorsFromAllExperimentsProvider
extends AbstractTableModelProvider<MaterialSimpleFeatureVectorSummary> {
    private final IScreeningServer server;
    private final String sessionToken;
    private final WellSearchCriteria.MaterialFeaturesManyExpCriteria criteria;

    public MaterialFeatureVectorsFromAllExperimentsProvider(IScreeningServer server, String sessionToken, WellSearchCriteria.MaterialFeaturesManyExpCriteria criteria) {
        this.server = server;
        this.sessionToken = sessionToken;
        this.criteria = criteria;
    }

    @Override
    public TypedTableModel<MaterialSimpleFeatureVectorSummary> createTableModel() {
        TypedTableModelBuilder<MaterialSimpleFeatureVectorSummary> builder = new TypedTableModelBuilder<MaterialSimpleFeatureVectorSummary>();
        List<MaterialSimpleFeatureVectorSummary> summaries = this.server.getMaterialFeatureVectorsFromAllExperiments(this.sessionToken, this.criteria);
        builder.addColumn("ASSAY");
        this.createFeatureColumns(builder, summaries);
        for (MaterialSimpleFeatureVectorSummary row : summaries) {
            this.addRow(builder, row);
        }
        return builder.getModel();
    }

    private void createFeatureColumns(TypedTableModelBuilder<MaterialSimpleFeatureVectorSummary> builder, List<MaterialSimpleFeatureVectorSummary> summaries) {
        for (MaterialSimpleFeatureVectorSummary summary : summaries) {
            for (CodeAndLabel codeAndLabel : summary.getFeatureDescriptions()) {
                builder.column(this.getFeatureValueColumnId(codeAndLabel)).withTitle(codeAndLabel.getLabel());
                if (!this.criteria.isComputeRanks()) continue;
                builder.column(this.getFeatureRankColumnId(codeAndLabel)).withTitle("Rank");
            }
        }
    }

    private void addRow(TypedTableModelBuilder<MaterialSimpleFeatureVectorSummary> builder, MaterialSimpleFeatureVectorSummary row) {
        builder.addRow(row);
        ExperimentReference experiment = row.getExperiment();
        builder.column("ASSAY").addString(experiment.getCode());
        float[] features = row.getFeatureVectorSummary();
        int[] ranks = row.getFeatureVectorRanks();
        List<CodeAndLabel> descriptions = row.getFeatureDescriptions();
        int i = 0;
        while (i < features.length) {
            CodeAndLabel description = descriptions.get(i);
            builder.column(this.getFeatureValueColumnId(description)).addDouble(Double.valueOf(features[i]));
            if (this.criteria.isComputeRanks()) {
                builder.column(this.getFeatureRankColumnId(description)).addInteger(new Long(ranks[i]));
            }
            ++i;
        }
    }

    private String getFeatureValueColumnId(CodeAndLabel codeAndLabel) {
        return "value-" + codeAndLabel.getCode();
    }

    private String getFeatureRankColumnId(CodeAndLabel codeAndLabel) {
        return "rank-" + codeAndLabel.getCode();
    }
}

