/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server;

import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.plugin.AbstractPluginBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningDAOFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ExperimentMetadaLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.IExperimentMetadataLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellFeatureVectorReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.HCSDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.HCSImageResolutionLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IHCSFeatureVectorLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IImageDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IImageResolutionLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="screening-bo-factory")
public final class ScreeningBusinessObjectFactory
extends AbstractPluginBusinessObjectFactory
implements IScreeningBusinessObjectFactory {
    @Resource(name="screening-dao-factory")
    private IScreeningDAOFactory specificDAOFactory;

    @Override
    public IImageDatasetLoader tryCreateImageDatasetLoader(String datasetCode, String datastoreCode) {
        return HCSDatasetLoader.tryCreate(this.specificDAOFactory.getImagingQueryDAO(datastoreCode), datasetCode);
    }

    @Override
    public IImageResolutionLoader tryCreateImageResolutionLoader(String datasetCode, String datastoreCode) {
        return HCSImageResolutionLoader.tryCreate(this.specificDAOFactory.getImagingQueryDAO(datastoreCode), datasetCode);
    }

    @Override
    public IHCSFeatureVectorLoader createHCSFeatureVectorLoader(String datastoreCode) {
        final IImagingReadonlyQueryDAO dao = this.specificDAOFactory.getImagingQueryDAO(datastoreCode);
        return new IHCSFeatureVectorLoader(){

            @Override
            public FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> fetchWellFeatureValuesIfPossible(Session session, List<WellFeatureVectorReference> references) {
                return FeatureVectorLoader.fetchWellFeatureValuesIfPossible(references, dao, ScreeningBusinessObjectFactory.this.getProvider(session));
            }

            @Override
            public FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> fetchDatasetFeatureValues(Session session, List<String> datasetCodes, List<String> featureCodes) {
                return FeatureVectorLoader.fetchWellFeatureCollection(datasetCodes, featureCodes, dao, ScreeningBusinessObjectFactory.this.getProvider(session));
            }
        };
    }

    FeatureVectorLoader.IMetadataProvider getProvider(final Session session) {
        return new FeatureVectorLoader.IMetadataProvider(){
            private IDatasetLister lister;

            @Override
            public void getSampleIdentifiers(List<String> samplePermIds) {
            }

            @Override
            public SampleIdentifier tryGetSampleIdentifier(String samplePermId) {
                return null;
            }

            @Override
            public List<String> tryGetContainedDatasets(String datasetCode) {
                List<String> result = this.getLister().listContainedCodes(datasetCode);
                return result;
            }

            private IDatasetLister getLister() {
                if (this.lister == null) {
                    this.lister = ScreeningBusinessObjectFactory.this.createDatasetLister(session);
                }
                return this.lister;
            }
        };
    }

    @Override
    public IExperimentMetadataLoader createExperimentMetadataLoader(long experimentId, List<String> dataStoreCodes) {
        return new ExperimentMetadaLoader(experimentId, this.getImagingQueries(dataStoreCodes));
    }

    private List<IImagingReadonlyQueryDAO> getImagingQueries(List<String> dataStoreCodes) {
        ArrayList<IImagingReadonlyQueryDAO> imagingQueries = new ArrayList<IImagingReadonlyQueryDAO>();
        for (String dataStoreCode : dataStoreCodes) {
            imagingQueries.add(this.specificDAOFactory.getImagingQueryDAO(dataStoreCode));
        }
        return imagingQueries;
    }

    @Override
    public final ISampleBO createSampleBO(Session session) {
        return this.getCommonBusinessObjectFactory().createSampleBO(session);
    }

    @Override
    public ISampleLister createSampleLister(Session session) {
        return this.getCommonBusinessObjectFactory().createSampleLister(session);
    }

    @Override
    public IMaterialLister createMaterialLister(Session session) {
        return this.getCommonBusinessObjectFactory().createMaterialLister(session);
    }

    @Override
    public IDataSetTable createDataSetTable(Session session) {
        return this.getCommonBusinessObjectFactory().createDataSetTable(session);
    }

    @Override
    public IExperimentBO createExperimentBO(Session session) {
        return this.getCommonBusinessObjectFactory().createExperimentBO(session);
    }

    @Override
    public IMaterialBO createMaterialBO(Session session) {
        return this.getCommonBusinessObjectFactory().createMaterialBO(session);
    }

    @Override
    public IDataBO createDataBO(Session session) {
        return this.getCommonBusinessObjectFactory().createDataBO(session);
    }

    @Override
    public IDatasetLister createDatasetLister(Session session) {
        return this.getCommonBusinessObjectFactory().createDatasetLister(session);
    }
}

