/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import java.util.Set;

public final class ScreeningPlateValidator
extends AbstractValidator<Plate> {
    @Override
    public final boolean doValidation(PersonPE person, Plate value) {
        String spaceCode = value.tryGetSpaceCode();
        if (spaceCode != null) {
            Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
            for (RoleAssignmentPE roleAssignment : roleAssignments) {
                if (roleAssignment.getDatabaseInstance() != null) {
                    return true;
                }
                SpacePE group = roleAssignment.getSpace();
                if (group == null || !group.getCode().equals(spaceCode)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

