/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

class PlateDatasetLoader {
    protected final Session session;
    protected final IScreeningBusinessObjectFactory businessObjectFactory;
    private final Set<? extends PlateIdentifier> plates;
    private final String[] datasetTypeCodePatterns;
    private String homeSpaceOrNull;
    private List<Sample> samples;
    private List<AbstractExternalData> datasets;
    private HashMap<SampleIdentifier, Sample> samplesByIdentifier;
    private HashMap<Long, Sample> samplesById;
    private Set<Long> initialSampleIds;
    private boolean loaded = false;

    PlateDatasetLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, String homeSpaceOrNull, Set<? extends PlateIdentifier> plates, String ... datasetTypeCodes) {
        this.session = session;
        this.businessObjectFactory = businessObjectFactory;
        this.homeSpaceOrNull = homeSpaceOrNull != null ? "/" + homeSpaceOrNull + "/" : null;
        this.plates = plates;
        this.datasetTypeCodePatterns = datasetTypeCodes;
    }

    protected List<AbstractExternalData> getDatasets() {
        return this.datasets;
    }

    protected void load() {
        if (!this.loaded) {
            this.loadSamples();
            this.loadDatasets();
            this.loaded = true;
        }
    }

    private void loadSamples() {
        String[] sampleCodesArray = this.extractSampleCodes();
        String[] samplePermIdArray = this.extractPermIds();
        ListOrSearchSampleCriteria criteria = new ListOrSearchSampleCriteria(sampleCodesArray, samplePermIdArray);
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        this.samples = sampleLister.list(criteria);
        this.initializeSampleMaps();
        this.filterSamplesByPlateIdentifiers();
    }

    private void loadDatasets() {
        IDatasetLister datasetLister = this.businessObjectFactory.createDatasetLister(this.session);
        this.datasets = datasetLister.listBySampleIds(this.initialSampleIds);
        this.datasets = ScreeningUtils.filterExternalDataByTypePattern(this.datasets, this.datasetTypeCodePatterns);
    }

    private void initializeSampleMaps() {
        this.samplesByIdentifier = new HashMap();
        this.samplesById = new HashMap();
        for (Sample sample : this.samples) {
            this.samplesByIdentifier.put(PlateDatasetLoader.createSampleIdentifier(sample), sample);
            this.samplesById.put(sample.getId(), sample);
        }
        this.initialSampleIds = new HashSet<Long>(this.samplesById.keySet());
    }

    private void filterSamplesByPlateIdentifiers() {
        HashSet<String> augmentedCodeSet = new HashSet<String>(this.plates.size());
        HashSet<String> permIdSet = new HashSet<String>(this.plates.size());
        for (PlateIdentifier plateIdentifier : this.plates) {
            if (plateIdentifier.getPermId() != null) {
                permIdSet.add(plateIdentifier.getPermId());
                continue;
            }
            if (SpaceCodeHelper.isHomeSpace(plateIdentifier.tryGetSpaceCode())) {
                if (this.homeSpaceOrNull == null) {
                    throw UserFailureException.fromTemplate("Plate '%s' is in home space, but user has no home space defined.", plateIdentifier);
                }
                augmentedCodeSet.add(String.valueOf(this.homeSpaceOrNull) + plateIdentifier.getAugmentedCode());
                continue;
            }
            augmentedCodeSet.add(plateIdentifier.getAugmentedCode());
        }
        Iterator<Sample> iterator = this.samples.iterator();
        while (iterator.hasNext()) {
            String augmentedCode;
            Sample sample = iterator.next();
            String sampleSpaceCodeOrNull = sample.getSpace() == null ? null : sample.getSpace().getCode();
            String string = augmentedCode = sampleSpaceCodeOrNull == null ? "/" + sample.getCode() : "/" + sampleSpaceCodeOrNull + "/" + sample.getCode();
            if (permIdSet.contains(sample.getPermId()) || augmentedCodeSet.contains(augmentedCode)) continue;
            iterator.remove();
            this.samplesByIdentifier.remove(PlateDatasetLoader.createSampleIdentifier(sample));
            this.samplesById.remove(sample.getId());
        }
    }

    protected PlateIdentifier createPlateIdentifier(AbstractExternalData dataSet) {
        Sample sample = this.getSample(dataSet);
        String plateCode = sample.getCode();
        Space space = sample.getSpace();
        String spaceCodeOrNull = space != null ? space.getCode() : null;
        return new PlateIdentifier(plateCode, spaceCodeOrNull, sample.getPermId());
    }

    protected static ExperimentIdentifier createExperimentIdentifier(AbstractExternalData parentDataset) {
        return PlateDatasetLoader.asExperimentIdentifier(parentDataset.getExperiment());
    }

    private static ExperimentIdentifier asExperimentIdentifier(Experiment experiment) {
        ExperimentIdentifier experimentId = new ExperimentIdentifier(experiment.getCode(), experiment.getProject().getCode(), experiment.getProject().getSpace().getCode(), experiment.getPermId());
        return experimentId;
    }

    protected Geometry extractPlateGeometry(AbstractExternalData dataSet) {
        Sample sample = this.getSample(dataSet);
        List<IEntityProperty> properties = sample.getProperties();
        for (IEntityProperty property : properties) {
            PropertyType propertyType = property.getPropertyType();
            if (!propertyType.getCode().equals("$PLATE_GEOMETRY")) continue;
            String code = property.getVocabularyTerm().getCode();
            try {
                return Geometry.createFromPlateGeometryString(code);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UserFailureException("Invalid property $PLATE_GEOMETRY: " + code);
            }
        }
        throw new UserFailureException("Sample '" + sample.getIdentifier() + "' has no property " + "$PLATE_GEOMETRY");
    }

    protected Map<String, String> extractProperties(AbstractExternalData dataSet) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (dataSet.getProperties() != null) {
            for (IEntityProperty prop : dataSet.getProperties()) {
                String value = prop.tryGetAsString();
                if (value == null) continue;
                properties.put(prop.getPropertyType().getCode(), value);
            }
        }
        return properties;
    }

    private Sample getSample(AbstractExternalData dataset) {
        Sample sample = dataset.getSample();
        assert (sample != null) : "dataset not connected to a sample: " + dataset;
        if (sample == null) {
            throw new IllegalStateException("dataset not connected to a sample: " + dataset);
        }
        Sample result = this.samplesById.get(sample.getId());
        if (result == null) {
            ListOrSearchSampleCriteria criteria = new ListOrSearchSampleCriteria(Collections.singletonList(sample.getId()));
            ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
            this.samples = sampleLister.list(criteria);
            assert (this.samples.size() == 1);
            result = this.samples.get(0);
            this.samplesById.put(sample.getId(), result);
        }
        return result;
    }

    private String[] extractSampleCodes() {
        ArrayList<String> sampleCodes = new ArrayList<String>();
        for (PlateIdentifier plateIdentifier : this.plates) {
            if (plateIdentifier.getPlateCode() == null || plateIdentifier.getPermId() != null) continue;
            sampleCodes.add(plateIdentifier.getPlateCode());
        }
        String[] stringArray = new String[sampleCodes.size()];
        sampleCodes.toArray(stringArray);
        return stringArray;
    }

    private String[] extractPermIds() {
        ArrayList<String> samplePermIds = new ArrayList<String>();
        for (PlateIdentifier plateIdentifier : this.plates) {
            if (plateIdentifier.getPermId() == null) continue;
            samplePermIds.add(plateIdentifier.getPermId());
        }
        String[] stringArray = new String[samplePermIds.size()];
        samplePermIds.toArray(stringArray);
        return stringArray;
    }

    protected static String getDataStoreUrlFromDataStore(DataStore dataStore) {
        String datastoreUrl = dataStore.getHostUrl();
        if (datastoreUrl.endsWith("/")) {
            datastoreUrl = datastoreUrl.substring(0, datastoreUrl.length() - 1);
        }
        return datastoreUrl;
    }

    protected static SampleIdentifier createSampleIdentifier(PlateIdentifier plate, String homeSpaceCodeOrNull) {
        SampleOwnerIdentifier owner;
        String spaceCode = plate.tryGetSpaceCode();
        if (StringUtils.isNotBlank((String)spaceCode)) {
            SpaceIdentifier space = new SpaceIdentifier(DatabaseInstanceIdentifier.HOME, spaceCode);
            owner = new SampleOwnerIdentifier(space);
        } else if (spaceCode == null) {
            owner = new SampleOwnerIdentifier(DatabaseInstanceIdentifier.createHome());
        } else {
            if (homeSpaceCodeOrNull == null) {
                throw new UserFailureException("No space given and user has no home space.");
            }
            SpaceIdentifier space = new SpaceIdentifier(DatabaseInstanceIdentifier.HOME, homeSpaceCodeOrNull);
            owner = new SampleOwnerIdentifier(space);
        }
        return SampleIdentifier.createOwnedBy(owner, plate.getPlateCode());
    }

    protected static SampleIdentifier createSampleIdentifier(Sample sample) {
        SampleOwnerIdentifier owner;
        String spaceCode;
        Space spaceOrNull = sample.getSpace();
        String string = spaceCode = spaceOrNull == null ? null : spaceOrNull.getCode();
        if (spaceCode != null) {
            SpaceIdentifier space = new SpaceIdentifier(DatabaseInstanceIdentifier.HOME, spaceCode);
            owner = new SampleOwnerIdentifier(space);
        } else {
            owner = new SampleOwnerIdentifier(DatabaseInstanceIdentifier.createHome());
        }
        return SampleIdentifier.createOwnedBy(owner, sample.getCode());
    }
}

