/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.BasicWellContentQueryResult;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningQuery;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.PatternMatchingUtils;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.WellContentQueryResult;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.AbstractContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.WellFeatureCollectionLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.WellReplicaSummaryCalculator;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.IWellData;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.MaterialIdFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.WellData;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.WellExtendedData;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSimpleFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSummarySettings;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.DataIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.time.StopWatch;

class WellDataLoader
extends AbstractContentLoader {
    private final MaterialSummarySettings settings;

    public WellDataLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, IScreeningQuery screeningQuery, MaterialSummarySettings settings) {
        super(session, businessObjectFactory, daoFactory, screeningQuery);
        this.settings = settings;
    }

    public List<WellExtendedData> tryLoadWellData(WellSearchCriteria.MaterialFeaturesOneExpCriteria criteria) {
        TechId materialId = criteria.getMaterialId();
        List<WellContentQueryResult> wells = this.getPlateLocationsForMaterialId(materialId, criteria.getExperimentId());
        List<WellData> wellsData = this.tryCreateWellDataForMaterial(wells, materialId, criteria.getAnalysisProcedureCriteria());
        if (wellsData == null) {
            return null;
        }
        Map<WellReference, Sample> wellRefToSampleMap = this.loadEnrichedWellSamples(wells);
        return this.createWellExtendedData(wellsData, wellRefToSampleMap);
    }

    private List<WellContentQueryResult> getPlateLocationsForMaterialId(TechId materialId, TechId experimentId) {
        DataIterator<WellContentQueryResult> wellsIterator = this.getScreeningDAO().getPlateLocationsForMaterialId(materialId.getId(), experimentId.getId());
        ArrayList<WellContentQueryResult> wells = new ArrayList<WellContentQueryResult>();
        for (WellContentQueryResult well : wellsIterator) {
            wells.add(well);
        }
        return wells;
    }

    private Map<WellReference, Sample> loadEnrichedWellSamples(Iterable<WellContentQueryResult> wells) {
        Set<Long> wellIds = WellDataLoader.extractWellIds(wells);
        List<Sample> wellSamples = this.loadSamplesWithMaterialPropertiesEnriched(wellIds);
        return WellDataLoader.asWellRefToSampleMap(wellSamples, wells);
    }

    private List<WellData> tryCreateWellDataForMaterial(Iterable<WellContentQueryResult> wells, TechId materialId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> allWellFeatures = this.tryLoadWellSingleFeatureVectors(wells, analysisProcedureCriteria);
        if (allWellFeatures == null) {
            return null;
        }
        List<FeatureVectorValues> features = allWellFeatures.getFeatures();
        Map<WellReference, Long> dummyMaterialMap = this.createDummyMaterialMap(wells, materialId);
        return WellDataLoader.createWellData(dummyMaterialMap, features);
    }

    private Map<WellReference, Long> createDummyMaterialMap(Iterable<WellContentQueryResult> wells, TechId materialId) {
        HashMap<WellReference, Long> experimentWellToMaterialMap = new HashMap<WellReference, Long>();
        for (WellContentQueryResult well : wells) {
            WellReference wellReference = well.getWellReference();
            experimentWellToMaterialMap.put(wellReference, materialId.getId());
        }
        return experimentWellToMaterialMap;
    }

    private static Map<WellReference, Sample> asWellRefToSampleMap(List<Sample> wellSamples, Iterable<WellContentQueryResult> wells) {
        HashMap<WellReference, Sample> wellRefToSampleMap = new HashMap<WellReference, Sample>();
        Map<Long, Sample> idToSampleMap = WellDataLoader.asSampleIdMap(wellSamples);
        for (WellContentQueryResult well : wells) {
            Sample sample = idToSampleMap.get(well.well_id);
            wellRefToSampleMap.put(well.getWellReference(), sample);
        }
        return wellRefToSampleMap;
    }

    private List<WellExtendedData> createWellExtendedData(List<WellData> wellsData, final Map<WellReference, Sample> wellRefToSampleMap) {
        Collection data = CollectionUtils.collect(wellsData, (Transformer)new Transformer<WellData, WellExtendedData>(){

            public WellExtendedData transform(WellData wellData) {
                WellReference wellReference = wellData.tryGetWellReference();
                if (!$assertionsDisabled && wellReference == null) {
                    throw new AssertionError((Object)("wellReference not available for " + wellData));
                }
                Sample wellSample = (Sample)wellRefToSampleMap.get(wellReference);
                if (!$assertionsDisabled && wellSample == null) {
                    throw new AssertionError((Object)("Cannot find a sample for " + wellReference));
                }
                return new WellExtendedData(wellData, wellSample);
            }
        });
        return new LinkedList<WellExtendedData>(data);
    }

    private static Map<Long, Sample> asSampleIdMap(List<Sample> samples) {
        HashMap<Long, Sample> map = new HashMap<Long, Sample>();
        for (Sample sample : samples) {
            map.put(sample.getId(), sample);
        }
        return map;
    }

    private List<Sample> loadSamplesWithMaterialPropertiesEnriched(Set<Long> wellIds) {
        ListOrSearchSampleCriteria criteria = new ListOrSearchSampleCriteria(wellIds);
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        List<Sample> wellSamples = sampleLister.list(criteria);
        IMaterialLister materialLister = this.businessObjectFactory.createMaterialLister(this.session);
        List<Material> containedMaterials = WellDataLoader.getMaterialsWithDuplicates(wellSamples);
        materialLister.enrichWithProperties(containedMaterials);
        return wellSamples;
    }

    private static List<Material> getMaterialsWithDuplicates(List<Sample> samples) {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (Sample sample : samples) {
            for (IEntityProperty property : sample.getProperties()) {
                Material materialOrNull = property.getMaterial();
                if (materialOrNull == null) continue;
                materials.add(materialOrNull);
            }
        }
        return materials;
    }

    private static Set<Long> extractWellIds(Iterable<WellContentQueryResult> wells) {
        HashSet<Long> ids = new HashSet<Long>();
        for (WellContentQueryResult well : wells) {
            ids.add(well.well_id);
        }
        return ids;
    }

    public List<MaterialSimpleFeatureVectorSummary> loadMaterialFeatureVectorsFromAllAssaysBatch(TechId materialId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean computeRanks, List<ExperimentReference> experiments) {
        ArrayList<MaterialSimpleFeatureVectorSummary> summaries = new ArrayList<MaterialSimpleFeatureVectorSummary>();
        StopWatch watch = this.createWatchAndStart();
        int totalWellsLoaded = 0;
        int totalFeatureVectorsLoaded = 0;
        List<BasicWellContentQueryResult> allWells = computeRanks ? this.fetchWellLocations(materialId, WellDataLoader.extractIds(experiments)) : this.fetchWellLocationsForMaterial(materialId, WellDataLoader.extractIds(experiments));
        totalWellsLoaded += allWells.size();
        FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> allWellFeaturesOrNull = this.tryLoadWellSingleFeatureVectors(allWells, analysisProcedureCriteria);
        if (allWellFeaturesOrNull == null) {
            this.addEmptySummaries(summaries, experiments);
        } else {
            for (ExperimentReference experiment : experiments) {
                totalFeatureVectorsLoaded += allWellFeaturesOrNull.getFeatures().size();
                List<BasicWellContentQueryResult> experimentWells = WellDataLoader.filterExperimentWells(allWells, experiment.getPermId());
                List<MaterialIdFeatureVectorSummary> experimentSummaries = this.calculateExperimentFeatureVectorSummaries(experimentWells, allWellFeaturesOrNull, false);
                MaterialSimpleFeatureVectorSummary summary = this.tryFindExperimentFeatureVectorSummary(materialId, experiment, allWellFeaturesOrNull.getFeatureCodesAndLabels(), experimentSummaries);
                if (summary != null) {
                    summaries.add(summary);
                    continue;
                }
                summaries.add(new MaterialSimpleFeatureVectorSummary(experiment));
            }
        }
        operationLog.info((Object)String.format("[%d msec] Experiments batch: %d, wells loaded: %d, feature vectors: %d.", watch.getTime(), experiments.size(), totalWellsLoaded, totalFeatureVectorsLoaded));
        return summaries;
    }

    private List<BasicWellContentQueryResult> fetchWellLocationsForMaterial(TechId materialId, long[] experimentIds) {
        StopWatch watch = this.createWatchAndStart();
        List<BasicWellContentQueryResult> wells = this.getScreeningDAO().getPlateLocationsForExperiment(experimentIds, materialId.getId());
        operationLog.info((Object)("[" + watch.getTime() + " msec] Fetching " + wells.size() + " wells for 1 material."));
        return wells;
    }

    private static long[] extractIds(List<ExperimentReference> experiments) {
        long[] ids = new long[experiments.size()];
        int i = 0;
        for (ExperimentReference experiment : experiments) {
            ids[i++] = experiment.getId();
        }
        return ids;
    }

    private void addEmptySummaries(List<MaterialSimpleFeatureVectorSummary> summaries, List<ExperimentReference> experiments) {
        for (ExperimentReference experiment : experiments) {
            summaries.add(new MaterialSimpleFeatureVectorSummary(experiment));
        }
    }

    private List<BasicWellContentQueryResult> fetchWellLocations(TechId materialId, TechId experimentId) {
        return this.fetchWellLocations(materialId, new long[]{experimentId.getId()});
    }

    private List<BasicWellContentQueryResult> fetchWellLocations(TechId materialId, long[] experimentIds) {
        String materialTypeCode = this.fetchMaterialTypeCode(materialId);
        return this.fetchWellLocations(materialTypeCode, experimentIds);
    }

    private List<BasicWellContentQueryResult> fetchWellLocations(String materialTypeCodePattern, long[] experimentIds) {
        StopWatch watch = this.createWatchAndStart();
        List<BasicWellContentQueryResult> wells = this.getScreeningDAO().getPlateLocationsForExperiment(experimentIds, materialTypeCodePattern);
        operationLog.info((Object)("[" + watch.getTime() + " msec] Fetching " + wells.size() + " wells."));
        return wells;
    }

    private List<MaterialIdFeatureVectorSummary> calculateExperimentFeatureVectorSummaries(Iterable<BasicWellContentQueryResult> wells, FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> allWellFeatures, boolean calculateDeviations) {
        List<WellData> experimentWellData = this.createWellData(wells, allWellFeatures);
        return this.calculateExperimentFeatureVectorSummaries(experimentWellData, calculateDeviations);
    }

    private List<WellData> createWellData(Iterable<BasicWellContentQueryResult> wells, FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> allWellFeatures) {
        Map<WellReference, Long> wellToMaterialMap = WellDataLoader.createWellToMaterialMap(wells);
        return WellDataLoader.createWellData(wellToMaterialMap, allWellFeatures.getFeatures());
    }

    private String fetchMaterialTypeCode(TechId materialId) {
        IMaterialBO materialBO = this.businessObjectFactory.createMaterialBO(this.session);
        materialBO.loadDataByTechId(materialId);
        return materialBO.getMaterial().getEntityType().getCode();
    }

    private static Map<WellReference, Long> createWellToMaterialMap(Iterable<BasicWellContentQueryResult> wells) {
        HashMap<WellReference, Long> wellToMaterialMap = new HashMap<WellReference, Long>();
        for (BasicWellContentQueryResult well : wells) {
            WellReference wellReference = well.getWellReference();
            wellToMaterialMap.put(wellReference, well.material_content_id);
        }
        return wellToMaterialMap;
    }

    private static List<BasicWellContentQueryResult> filterExperimentWells(List<BasicWellContentQueryResult> wells, final String experimentPermId) {
        Collection filtered = CollectionUtils.select(wells, (Predicate)new Predicate<BasicWellContentQueryResult>(){

            public boolean evaluate(BasicWellContentQueryResult well) {
                return WellDataLoader.belongsToExperiment(well, experimentPermId);
            }
        });
        return new LinkedList<BasicWellContentQueryResult>(filtered);
    }

    private static boolean belongsToExperiment(BasicWellContentQueryResult well, String experimentPermId) {
        return well.exp_perm_id.equals(experimentPermId);
    }

    private MaterialSimpleFeatureVectorSummary tryFindExperimentFeatureVectorSummary(TechId materialId, ExperimentReference experiment, List<CodeAndLabel> features, List<MaterialIdFeatureVectorSummary> experimentSummaries) {
        MaterialIdFeatureVectorSummary materialSummary = WellDataLoader.tryFindMaterialSummary(materialId, experimentSummaries);
        if (materialSummary == null) {
            return null;
        }
        return new MaterialSimpleFeatureVectorSummary(experiment, features, materialSummary.getFeatureVectorSummary(), materialSummary.getFeatureVectorRanks());
    }

    private List<MaterialIdFeatureVectorSummary> calculateExperimentFeatureVectorSummaries(List<? extends IWellData> experimentWellData, boolean calculateDeviations) {
        return WellReplicaSummaryCalculator.calculateReplicasFeatureVectorSummaries(experimentWellData, this.settings.getAggregationType(), calculateDeviations);
    }

    private static MaterialIdFeatureVectorSummary tryFindMaterialSummary(TechId materialId, List<MaterialIdFeatureVectorSummary> summaries) {
        for (MaterialIdFeatureVectorSummary summary : summaries) {
            if (!((Long)summary.getMaterial()).equals(materialId.getId())) continue;
            return summary;
        }
        return null;
    }

    private static List<WellData> createWellData(Map<WellReference, Long> experimentWellToMaterialMap, List<FeatureVectorValues> allFeatures) {
        ArrayList<WellData> experimentWellDataList = new ArrayList<WellData>();
        for (FeatureVectorValues feature : allFeatures) {
            WellReference wellReference = feature.getWellReference();
            Long materialId = experimentWellToMaterialMap.get(wellReference);
            if (materialId == null) continue;
            float[] values = WellFeatureCollectionLoader.asFeatureVectorValues(feature);
            WellData wellData = new WellData(materialId, values, wellReference);
            experimentWellDataList.add(wellData);
        }
        return experimentWellDataList;
    }

    private static Set<PlateIdentifier> extractPlates(Iterable<? extends IWellReference> allWells) {
        HashSet<PlateIdentifier> plates = new HashSet<PlateIdentifier>();
        for (IWellReference iWellReference : allWells) {
            String platePermId = iWellReference.getPlatePermId();
            PlateIdentifier plateIdent = PlateIdentifier.createFromPermId(platePermId);
            plates.add(plateIdent);
        }
        return plates;
    }

    private FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> tryLoadWellSingleFeatureVectors(Iterable<? extends IWellReference> allWells, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        Set<PlateIdentifier> plates = WellDataLoader.extractPlates(allWells);
        return this.tryLoadWellSingleFeatureVectors(plates, analysisProcedureCriteria);
    }

    private FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> tryLoadWellSingleFeatureVectors(Set<PlateIdentifier> plates, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        return new WellFeatureCollectionLoader(this.session, this.businessObjectFactory, this.daoFactory, null).tryLoadWellSingleFeatureVectors(plates, this.settings.getFeatureCodes(), analysisProcedureCriteria);
    }

    public MaterialIdSummariesAndFeatures tryCalculateExperimentFeatureVectorSummaries(TechId experimentId, String[] replicaMaterialTypeSubstrings, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean calculateDeviations) {
        String typePatterns = PatternMatchingUtils.asPostgresSimilarExpression(this.settings.getReplicaMaterialTypeSubstrings());
        List<BasicWellContentQueryResult> wells = this.fetchWellLocations(typePatterns, new long[]{experimentId.getId()});
        return this.tryCalculateExperimentFeatureVectorSummaries(wells, analysisProcedureCriteria, calculateDeviations);
    }

    public MaterialIdSummariesAndFeatures tryCalculateExperimentFeatureVectorSummaries(WellSearchCriteria.MaterialFeaturesOneExpCriteria criteria, boolean calculateDeviations) {
        List<BasicWellContentQueryResult> wells = this.fetchWellLocations(criteria.getMaterialId(), criteria.getExperimentId());
        return this.tryCalculateExperimentFeatureVectorSummaries(wells, criteria.getAnalysisProcedureCriteria(), calculateDeviations);
    }

    private MaterialIdSummariesAndFeatures tryCalculateExperimentFeatureVectorSummaries(List<BasicWellContentQueryResult> wells, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean calculateDeviations) {
        FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> allWellFeatures = this.tryLoadWellSingleFeatureVectors(wells, analysisProcedureCriteria);
        if (allWellFeatures == null) {
            return null;
        }
        List<MaterialIdFeatureVectorSummary> featureSummaries = this.calculateExperimentFeatureVectorSummaries(wells, allWellFeatures, calculateDeviations);
        return new MaterialIdSummariesAndFeatures(featureSummaries, allWellFeatures.getFeatureCodesAndLabels());
    }

    static class MaterialIdSummariesAndFeatures {
        private final List<MaterialIdFeatureVectorSummary> featureSummaries;
        private final List<CodeAndLabel> featureNames;

        public MaterialIdSummariesAndFeatures(List<MaterialIdFeatureVectorSummary> featureSummaries, List<CodeAndLabel> featureNames) {
            this.featureSummaries = featureSummaries;
            this.featureNames = featureNames;
        }

        public List<MaterialIdFeatureVectorSummary> getFeatureSummaries() {
            return this.featureSummaries;
        }

        public List<CodeAndLabel> getFeatureNames() {
            return this.featureNames;
        }
    }
}

