/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

@JsonObject(value="DatasetReference")
public class DatasetReference
extends DatasetIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PlateIdentifier plate;
    private ExperimentIdentifier experimentIdentifier;
    private Geometry plateGeometry;
    private Date registrationDate;
    private Map<String, String> properties = Collections.emptyMap();
    private String dataSetType;

    @Deprecated
    public DatasetReference(String datasetCode, String datastoreServerUrl, PlateIdentifier plate) {
        this(datasetCode, datastoreServerUrl, plate, null, null);
    }

    @Deprecated
    public DatasetReference(String datasetCode, String datastoreServerUrl, PlateIdentifier plate, Geometry plateGeometry, Date registrationDate) {
        this(datasetCode, datastoreServerUrl, plate, null, plateGeometry, registrationDate, null);
    }

    @Deprecated
    public DatasetReference(String datasetCode, String datastoreServerUrl, PlateIdentifier plateWithExperiment, ExperimentIdentifier experiment, Geometry plateGeometry, Date registrationDate, Map<String, String> propertiesOrNull) {
        this(datasetCode, null, datastoreServerUrl, plateWithExperiment, experiment, plateGeometry, registrationDate, propertiesOrNull);
    }

    public DatasetReference(String datasetCode, String dataSetTypeOrNull, String datastoreServerUrl, PlateIdentifier plateWithExperiment, ExperimentIdentifier experiment, Geometry plateGeometry, Date registrationDate, Map<String, String> propertiesOrNull) {
        super(datasetCode, datastoreServerUrl);
        this.dataSetType = dataSetTypeOrNull;
        this.plate = plateWithExperiment;
        this.experimentIdentifier = experiment == null ? DatasetReference.createFakeExperiment(this.plate) : experiment;
        this.plateGeometry = plateGeometry;
        this.registrationDate = registrationDate;
        if (propertiesOrNull != null) {
            this.properties = Collections.unmodifiableMap(propertiesOrNull);
        }
    }

    private static ExperimentIdentifier createFakeExperiment(PlateIdentifier plate) {
        return new ExperimentIdentifier("?", "?", plate == null ? "?" : plate.tryGetSpaceCode(), "?");
    }

    public String getDataSetType() {
        return this.dataSetType;
    }

    public final Geometry getPlateGeometry() {
        return this.plateGeometry;
    }

    public final Date getRegistrationDate() {
        return this.registrationDate;
    }

    public PlateIdentifier getPlate() {
        return this.plate;
    }

    public ExperimentIdentifier getExperimentIdentifier() {
        return this.experimentIdentifier;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.experimentIdentifier == null) {
            this.experimentIdentifier = DatasetReference.createFakeExperiment(this.plate);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " (plate: " + this.plate + ")";
    }

    private DatasetReference() {
        super(null, null);
    }

    private void setPlate(PlateIdentifier plate) {
        this.plate = plate;
    }

    private void setExperimentIdentifier(ExperimentIdentifier experimentIdentifier) {
        this.experimentIdentifier = experimentIdentifier;
    }

    private void setPlateGeometry(Geometry plateGeometry) {
        this.plateGeometry = plateGeometry;
    }

    private void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    private void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private void setDataSetType(String dataSetType) {
        this.dataSetType = dataSetType;
    }
}

