/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageChannel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonObject(value="ExperimentImageMetadata")
public class ExperimentImageMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ExperimentIdentifier identifier;
    private List<ImageChannel> channels;
    private Geometry plateGeometry;
    private Geometry tileGeometry;
    private ImageSize originalImageSize;
    private List<ImageSize> thumbnailImageSizes;

    public ExperimentImageMetadata(ExperimentIdentifier identifier, Geometry plateGeometry, Geometry tileGeometry, List<ImageChannel> channels, ImageSize originalImageSize, List<ImageSize> thumbnailImageSizes) {
        this.identifier = identifier;
        this.originalImageSize = originalImageSize;
        this.thumbnailImageSizes = thumbnailImageSizes;
        this.channels = new ArrayList<ImageChannel>(channels);
        this.plateGeometry = plateGeometry;
        this.tileGeometry = tileGeometry;
    }

    public ExperimentIdentifier getIdentifier() {
        return this.identifier;
    }

    public List<ImageChannel> getChannels() {
        return Collections.unmodifiableList(this.channels);
    }

    public Geometry getPlateGeometry() {
        return this.plateGeometry;
    }

    public Geometry getTileGeometry() {
        return this.tileGeometry;
    }

    public ImageSize getOriginalImageSize() {
        return this.originalImageSize;
    }

    public List<ImageSize> getThumbnailImageSizes() {
        return this.thumbnailImageSizes;
    }

    private ExperimentImageMetadata() {
    }

    private void setIdentifier(ExperimentIdentifier identifier) {
        this.identifier = identifier;
    }

    private void setChannels(List<ImageChannel> channels) {
        this.channels = channels;
    }

    private void setPlateGeometry(Geometry plateGeometry) {
        this.plateGeometry = plateGeometry;
    }

    private void setTileGeometry(Geometry tileGeometry) {
        this.tileGeometry = tileGeometry;
    }

    private void setOriginalImageSize(ImageSize originalImageSize) {
        this.originalImageSize = originalImageSize;
    }

    private void setThumbnailImageSizes(List<ImageSize> thumbnailImageSizes) {
        this.thumbnailImageSizes = thumbnailImageSizes;
    }
}

