/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IFeatureCodesProvider;
import java.io.Serializable;
import java.util.List;

@JsonObject(value="FeatureVectorDataset")
public class FeatureVectorDataset
implements Serializable,
IFeatureCodesProvider {
    private static final long serialVersionUID = 1L;
    private FeatureVectorDatasetReference dataset;
    private List<String> featureNames;
    private List<String> featureCodes;
    private List<String> featureLabels;
    private List<FeatureVector> featureVectors;

    public FeatureVectorDataset(FeatureVectorDatasetReference dataset, List<String> featureCodes, List<String> featureLabels, List<FeatureVector> featureVectors) {
        this.dataset = dataset;
        this.featureNames = featureCodes;
        this.featureCodes = featureCodes;
        this.featureLabels = featureLabels;
        this.featureVectors = featureVectors;
    }

    public FeatureVectorDatasetReference getDataset() {
        return this.dataset;
    }

    @Deprecated
    public List<String> getFeatureNames() {
        return this.featureNames;
    }

    @Override
    public List<String> getFeatureCodes() {
        return this.featureCodes == null ? this.featureNames : this.featureCodes;
    }

    public List<String> getFeatureLabels() {
        return this.featureLabels == null ? this.featureNames : this.featureLabels;
    }

    public List<FeatureVector> getFeatureVectors() {
        return this.featureVectors;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("datasetCode: " + this.dataset.getDatasetCode());
        sb.append(", storeUrl: " + this.dataset.getDatastoreServerUrl());
        sb.append("\n\tfeatures codes: " + this.getFeatureCodes());
        sb.append("\n\tfeatures labels: " + this.getFeatureLabels());
        if (this.featureVectors != null) {
            int i = 0;
            while (i < this.featureVectors.size()) {
                sb.append("\n\t" + this.featureVectors.get(i));
                ++i;
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FeatureVectorDataset)) {
            return false;
        }
        FeatureVectorDataset that = (FeatureVectorDataset)obj;
        return this.dataset.getDatasetCode().equals(that.getDataset().getDatasetCode());
    }

    public int hashCode() {
        return this.dataset.getDatasetCode().hashCode();
    }

    private FeatureVectorDataset() {
    }

    private void setDataset(FeatureVectorDatasetReference dataset) {
        this.dataset = dataset;
    }

    private void setFeatureNames(List<String> featureNames) {
        this.featureNames = featureNames;
    }

    private void setFeatureCodes(List<String> featureCodes) {
        this.featureCodes = featureCodes;
    }

    private void setFeatureLabels(List<String> featureLabels) {
        this.featureLabels = featureLabels;
    }

    private void setFeatureVectors(List<FeatureVector> featureVectors) {
        this.featureVectors = featureVectors;
    }
}

