/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import java.io.Serializable;

public class ExperimentReference
implements Serializable,
IEntityInformationHolderWithIdentifier {
    private static final long serialVersionUID = 35L;
    private long experimentId;
    private String experimentPermId;
    private String experimentCode;
    private String experimentTypeCode;
    private String projectCode;
    private String spaceCode;

    private ExperimentReference() {
    }

    public ExperimentReference(long experimentId, String experimentPermId, String experimentCode, String experimentTypeCode, String projectCode, String spaceCode) {
        this.experimentId = experimentId;
        this.experimentPermId = experimentPermId;
        this.experimentCode = experimentCode;
        this.experimentTypeCode = experimentTypeCode;
        this.projectCode = projectCode;
        this.spaceCode = spaceCode;
    }

    @Override
    public EntityKind getEntityKind() {
        return EntityKind.EXPERIMENT;
    }

    @Override
    public BasicEntityType getEntityType() {
        return new BasicEntityType(this.experimentTypeCode);
    }

    @Override
    public Long getId() {
        return this.experimentId;
    }

    @Override
    public String getCode() {
        return this.experimentCode;
    }

    @Override
    public String getIdentifier() {
        String SEP = "/";
        return String.valueOf(SEP) + this.spaceCode + SEP + this.projectCode + SEP + this.experimentCode;
    }

    @Override
    public String getPermId() {
        return this.experimentPermId;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public String getSpaceCode() {
        return this.spaceCode;
    }

    public String toString() {
        return this.getIdentifier();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.experimentId ^ this.experimentId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExperimentReference other = (ExperimentReference)obj;
        return this.experimentId == other.experimentId;
    }
}

