/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto;

import java.io.Serializable;

public class FeatureValue
implements Serializable {
    private static final long serialVersionUID = 35L;
    private static final FeatureValue EMPTY_VOCABULARY_TERM = new FeatureValue(null, null, true);
    private static final FeatureValue EMPTY_FLOAT_VALUE = new FeatureValue(Float.valueOf(Float.NaN), null, false);
    private Float floatValueOrNull;
    private String vocabularyTermValueOrNull;
    private boolean isVocabulary;

    public static final FeatureValue createVocabularyTerm(String value) {
        assert (value != null) : "vocabulary value is null";
        return new FeatureValue(null, value, true);
    }

    public static final FeatureValue createEmptyVocabularyTerm() {
        return EMPTY_VOCABULARY_TERM;
    }

    public static final FeatureValue createEmptyFloat() {
        return EMPTY_FLOAT_VALUE;
    }

    public static final FeatureValue createFloat(float value) {
        return new FeatureValue(Float.valueOf(value), null, false);
    }

    private FeatureValue() {
    }

    private FeatureValue(Float floatValueOrNull, String vocabularyTermValueOrNull, boolean isVocabulary) {
        assert (isVocabulary && floatValueOrNull == null || !isVocabulary && floatValueOrNull != null && vocabularyTermValueOrNull == null) : "invalid FeatureValue";
        this.floatValueOrNull = floatValueOrNull;
        this.vocabularyTermValueOrNull = vocabularyTermValueOrNull;
        this.isVocabulary = isVocabulary;
    }

    public boolean isFloat() {
        return !this.isVocabularyTerm();
    }

    public float asFloat() {
        assert (this.isFloat()) : "value is not a float";
        return this.floatValueOrNull.floatValue();
    }

    public boolean isVocabularyTerm() {
        return this.isVocabulary;
    }

    public String tryAsVocabularyTerm() {
        assert (this.isVocabularyTerm()) : "value is not a vocabulary";
        return this.vocabularyTermValueOrNull;
    }

    public String toString() {
        if (this.isVocabularyTerm()) {
            String term = this.tryAsVocabularyTerm();
            return term != null ? term : "";
        }
        if (this.isFloat()) {
            return "" + this.asFloat();
        }
        throw new IllegalStateException("unknown value");
    }
}

