/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.grids;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;

public class WellSearchGridColumnIds {
    public static final String EXPERIMENT = "experiment";
    public static final String PLATE = "PLATE";
    public static final String WELL = "WELL";
    public static final String IMAGE_DATA_SET = "IMAGE_DATA_SET";
    public static final String IMAGE_ANALYSIS_DATA_SET = "IMAGE_ANALYSIS_DATA_SET";
    public static final String FILE_FORMAT_TYPE = "file_format_type";
    public static final String WELL_IMAGES = "WELL_IMAGES";
    public static final String ANALYSIS_PROCEDURE = "ANALYSIS_PROCEDURE";
    private static final String MATERIAL_PROPERTY_GROUP = "MATERIAL_PROPERTY-";
    private static final String PROPERTY_CODE_MARKER = "$$$";

    public static String tryExtractWellMaterialPropertyCode(String columnId) {
        String userPropertyPrefix = "USER-";
        String propertyPrefix = PROPERTY_CODE_MARKER + userPropertyPrefix;
        int ix = columnId.indexOf(propertyPrefix);
        if (ix != -1) {
            return columnId.substring(ix + propertyPrefix.length());
        }
        return null;
    }

    public static String getWellMaterialColumnGroupPrefix(IEntityProperty wellMaterialProperty) {
        return MATERIAL_PROPERTY_GROUP + wellMaterialProperty.getPropertyType().getSimpleCode() + "-" + PROPERTY_CODE_MARKER;
    }

    public static String getWellMaterialPropertyColumnGroupPrefix(IEntityProperty materialProperty) {
        return "MATERIAL_PROPERTY-PROP-$$$" + materialProperty.getPropertyType().getSimpleCode() + "-";
    }
}

