/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.dto;

import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;

public class WellLocationUtils {
    public static int calcRow(Geometry geometry, int x, int y) {
        assert (geometry != null);
        assert (x >= 0 && x < geometry.getDimX()) : x;
        assert (y >= 0 && y < geometry.getDimY()) : y;
        return geometry.getDimY() - y;
    }

    public static int calcColumn(Geometry geometry, int x, int y) {
        assert (geometry != null);
        assert (x >= 0 && x < geometry.getDimX()) : "X is " + x + " (allowed: (0," + (geometry.getDimX() - 1) + ")";
        assert (y >= 0 && y < geometry.getDimY()) : "Y is " + y + " (allowed: (0," + (geometry.getDimY() - 1) + ")";
        return x + 1;
    }

    public static int calcX(Geometry geometry, int row, int col) {
        assert (geometry != null);
        assert (row > 0 && row <= geometry.getNumberOfRows()) : "Row is " + row + " (allowed: (1," + geometry.getNumberOfRows() + ")";
        assert (col > 0 && col <= geometry.getNumberOfColumns()) : "Col is " + col + " (allowed: (1," + geometry.getNumberOfColumns() + ")";
        return col - 1;
    }

    public static int calcX(Geometry geometry, WellLocation wellLocation) {
        return WellLocationUtils.calcX(geometry, wellLocation.getRow(), wellLocation.getColumn());
    }

    public static int calcY(Geometry geometry, WellLocation wellLocation) {
        return WellLocationUtils.calcY(geometry, wellLocation.getRow(), wellLocation.getColumn());
    }

    public static int calcY(Geometry geometry, int row, int col) {
        assert (geometry != null);
        assert (row > 0 && row <= geometry.getNumberOfRows()) : row;
        assert (col > 0 && col <= geometry.getNumberOfColumns()) : col;
        return geometry.getNumberOfRows() - row;
    }
}

