/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.collection.SynchronizedCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedBuffer<E>
extends SynchronizedCollection<E>
implements Buffer<E> {
    private static final long serialVersionUID = -6859936183953626253L;

    public static <E> Buffer<E> decorate(Buffer<E> buffer) {
        return new SynchronizedBuffer<E>(buffer);
    }

    protected SynchronizedBuffer(Buffer<E> buffer) {
        super(buffer);
    }

    protected SynchronizedBuffer(Buffer<E> buffer, Object lock) {
        super(buffer, lock);
    }

    protected Buffer<E> getBuffer() {
        return (Buffer)this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get() {
        Object object = this.lock;
        synchronized (object) {
            return this.getBuffer().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        Object object = this.lock;
        synchronized (object) {
            return this.getBuffer().remove();
        }
    }
}

