/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnboundedFifoBuffer<E>
extends AbstractCollection<E>
implements Buffer<E>,
Serializable {
    private static final long serialVersionUID = -3482960336579541419L;
    protected transient E[] buffer;
    protected transient int head;
    protected transient int tail;

    public UnboundedFifoBuffer() {
        this(32);
    }

    public UnboundedFifoBuffer(int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.buffer = new Object[initialSize + 1];
        this.head = 0;
        this.tail = 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size());
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            out.writeObject(it.next());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        this.buffer = new Object[size];
        int i = 0;
        while (i < size) {
            this.buffer[i] = in.readObject();
            ++i;
        }
        this.head = 0;
        this.tail = size;
    }

    @Override
    public int size() {
        int size = 0;
        size = this.tail < this.head ? this.buffer.length - this.head + this.tail : this.tail - this.head;
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(E obj) {
        if (obj == null) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.size() + 1 >= this.buffer.length) {
            Object[] tmp = new Object[(this.buffer.length - 1) * 2 + 1];
            int j = 0;
            int i = this.head;
            while (i != this.tail) {
                tmp[j] = this.buffer[i];
                this.buffer[i] = null;
                ++j;
                if (++i != this.buffer.length) continue;
                i = 0;
            }
            this.buffer = tmp;
            this.head = 0;
            this.tail = j;
        }
        this.buffer[this.tail] = obj;
        ++this.tail;
        if (this.tail >= this.buffer.length) {
            this.tail = 0;
        }
        return true;
    }

    @Override
    public E get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.buffer[this.head];
    }

    @Override
    public E remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        E element = this.buffer[this.head];
        if (element != null) {
            this.buffer[this.head] = null;
            ++this.head;
            if (this.head >= this.buffer.length) {
                this.head = 0;
            }
        }
        return element;
    }

    private int increment(int index) {
        if (++index >= this.buffer.length) {
            index = 0;
        }
        return index;
    }

    private int decrement(int index) {
        if (--index < 0) {
            index = this.buffer.length - 1;
        }
        return index;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index;
            private int lastReturnedIndex;
            {
                this.index = UnboundedFifoBuffer.this.head;
                this.lastReturnedIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return this.index != UnboundedFifoBuffer.this.tail;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index;
                this.index = UnboundedFifoBuffer.this.increment(this.index);
                return UnboundedFifoBuffer.this.buffer[this.lastReturnedIndex];
            }

            @Override
            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == UnboundedFifoBuffer.this.head) {
                    UnboundedFifoBuffer.this.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int i = this.lastReturnedIndex + 1;
                while (i != UnboundedFifoBuffer.this.tail) {
                    if (i >= UnboundedFifoBuffer.this.buffer.length) {
                        UnboundedFifoBuffer.this.buffer[i - 1] = UnboundedFifoBuffer.this.buffer[0];
                        i = 0;
                        continue;
                    }
                    UnboundedFifoBuffer.this.buffer[i - 1] = UnboundedFifoBuffer.this.buffer[i];
                    ++i;
                }
                this.lastReturnedIndex = -1;
                UnboundedFifoBuffer.this.tail = UnboundedFifoBuffer.this.decrement(UnboundedFifoBuffer.this.tail);
                UnboundedFifoBuffer.this.buffer[UnboundedFifoBuffer.this.tail] = null;
                this.index = UnboundedFifoBuffer.this.decrement(this.index);
            }
        };
    }
}

