/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.collection;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.collection.AbstractCollectionDecorator;
import org.apache.commons.collections.collection.AbstractSerializableCollectionDecorator;
import org.apache.commons.collections.collection.SynchronizedCollection;
import org.apache.commons.collections.iterators.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableBoundedCollection<E>
extends AbstractSerializableCollectionDecorator<E>
implements BoundedCollection<E> {
    private static final long serialVersionUID = -7112672385450340330L;

    public static <E> BoundedCollection<E> decorate(BoundedCollection<E> coll) {
        return new UnmodifiableBoundedCollection<E>(coll);
    }

    public static <E> BoundedCollection<E> decorateUsing(Collection<E> coll) {
        if (coll == null) {
            throw new IllegalArgumentException("The collection must not be null");
        }
        int i = 0;
        while (i < 1000) {
            if (coll instanceof BoundedCollection) break;
            if (coll instanceof AbstractCollectionDecorator) {
                coll = ((AbstractCollectionDecorator)coll).collection;
            } else {
                if (!(coll instanceof SynchronizedCollection)) break;
                coll = ((SynchronizedCollection)coll).collection;
            }
            ++i;
        }
        if (!(coll instanceof BoundedCollection)) {
            throw new IllegalArgumentException("The collection is not a bounded collection");
        }
        return new UnmodifiableBoundedCollection<E>((BoundedCollection)coll);
    }

    private UnmodifiableBoundedCollection(BoundedCollection<E> coll) {
        super(coll);
    }

    @Override
    public Iterator<E> iterator() {
        return UnmodifiableIterator.decorate(this.getCollection().iterator());
    }

    @Override
    public boolean add(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFull() {
        return ((BoundedCollection)this.collection).isFull();
    }

    @Override
    public int maxSize() {
        return ((BoundedCollection)this.collection).maxSize();
    }
}

