/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.PredicateDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AllPredicate<T>
implements Predicate<T>,
PredicateDecorator<T>,
Serializable {
    static final long serialVersionUID = -3094696765038308799L;
    private final Predicate<? super T>[] iPredicates;

    public static <T> Predicate<T> getInstance(Predicate<? super T>[] predicates) {
        FunctorUtils.validateMin2(predicates);
        predicates = FunctorUtils.copy(predicates);
        return new AllPredicate<T>(predicates);
    }

    public static <T> Predicate<T> getInstance(Collection<Predicate<? super T>> predicates) {
        Predicate<? super T>[] preds = FunctorUtils.validate(predicates);
        return new AllPredicate<T>(preds);
    }

    public AllPredicate(Predicate<? super T>[] predicates) {
        this.iPredicates = predicates;
    }

    @Override
    public boolean evaluate(T object) {
        int i = 0;
        while (i < this.iPredicates.length) {
            if (!this.iPredicates[i].evaluate(object)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Predicate<? super T>[] getPredicates() {
        return this.iPredicates;
    }
}

