/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhileClosure<T>
implements Closure<T>,
Serializable {
    static final long serialVersionUID = -3110538116913760108L;
    private final Predicate<? super T> iPredicate;
    private final Closure<? super T> iClosure;
    private final boolean iDoLoop;

    public static <T> Closure<T> getInstance(Predicate<? super T> predicate, Closure<? super T> closure, boolean doLoop) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        if (closure == null) {
            throw new IllegalArgumentException("Closure must not be null");
        }
        return new WhileClosure<T>(predicate, closure, doLoop);
    }

    public WhileClosure(Predicate<? super T> predicate, Closure<? super T> closure, boolean doLoop) {
        this.iPredicate = predicate;
        this.iClosure = closure;
        this.iDoLoop = doLoop;
    }

    @Override
    public void execute(T input) {
        if (this.iDoLoop) {
            this.iClosure.execute(input);
        }
        while (this.iPredicate.evaluate(input)) {
            this.iClosure.execute(input);
        }
    }

    public Predicate<? super T> getPredicate() {
        return this.iPredicate;
    }

    public Closure<? super T> getClosure() {
        return this.iClosure;
    }

    public boolean isDoLoop() {
        return this.iDoLoop;
    }
}

