/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections.BoundedMap;
import org.apache.commons.collections.collection.UnmodifiableCollection;
import org.apache.commons.collections.map.AbstractSortedMapDecorator;
import org.apache.commons.collections.set.UnmodifiableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeSortedMap<K, V>
extends AbstractSortedMapDecorator<K, V>
implements SortedMap<K, V>,
BoundedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 3126019624511683653L;

    public static <K, V> SortedMap<K, V> decorate(SortedMap<K, V> map) {
        return new FixedSizeSortedMap<K, V>(map);
    }

    protected FixedSizeSortedMap(SortedMap<K, V> map) {
        super(map);
    }

    @Override
    protected SortedMap<K, V> getSortedMap() {
        return (SortedMap)this.map;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    @Override
    public V put(K key, V value) {
        if (!this.map.containsKey(key)) {
            throw new IllegalArgumentException("Cannot put new key/value pair - Map is fixed size");
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> mapToCopy) {
        Iterator<K> it = mapToCopy.keySet().iterator();
        while (it.hasNext()) {
            if (mapToCopy.containsKey(it.next())) continue;
            throw new IllegalArgumentException("Cannot put new key/value pair - Map is fixed size");
        }
        this.map.putAll(mapToCopy);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Map is fixed size");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Map is fixed size");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = this.map.entrySet();
        return UnmodifiableSet.decorate(set);
    }

    @Override
    public Set<K> keySet() {
        Set set = this.map.keySet();
        return UnmodifiableSet.decorate(set);
    }

    @Override
    public Collection<V> values() {
        Collection coll = this.map.values();
        return UnmodifiableCollection.decorate(coll);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        SortedMap<K, V> map = this.getSortedMap().subMap(fromKey, toKey);
        return new FixedSizeSortedMap<K, V>(map);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        SortedMap<K, V> map = this.getSortedMap().headMap(toKey);
        return new FixedSizeSortedMap<K, V>(map);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        SortedMap<K, V> map = this.getSortedMap().tailMap(fromKey);
        return new FixedSizeSortedMap<K, V>(map);
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Override
    public int maxSize() {
        return this.size();
    }
}

