/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.AbstractHashedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityMap<K, V>
extends AbstractHashedMap<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2028493495224302329L;

    public IdentityMap() {
        super(16, 0.75f, 12);
    }

    public IdentityMap(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentityMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentityMap(Map<? extends K, ? extends V> map) {
        super(map);
    }

    @Override
    protected int hash(Object key) {
        return System.identityHashCode(key);
    }

    @Override
    protected boolean isEqualKey(Object key1, Object key2) {
        return key1 == key2;
    }

    @Override
    protected boolean isEqualValue(Object value1, Object value2) {
        return value1 == value2;
    }

    @Override
    protected AbstractHashedMap.HashEntry<K, V> createEntry(AbstractHashedMap.HashEntry<K, V> next, int hashCode, K key, V value) {
        return new IdentityEntry<K, V>(next, hashCode, key, value);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.doWriteObject(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.doReadObject(in);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IdentityEntry<K, V>
    extends AbstractHashedMap.HashEntry<K, V> {
        protected IdentityEntry(AbstractHashedMap.HashEntry<K, V> next, int hashCode, K key, V value) {
            super(next, hashCode, key, value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)obj;
            return this.getKey() == other.getKey() && this.getValue() == other.getValue();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.getKey()) ^ System.identityHashCode(this.getValue());
        }
    }
}

