/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageReference;
import ch.systemsx.cisd.openbis.dss.etl.Utils;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageTransfomationFactories;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorRGB;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.RequestedImageSize;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import java.awt.image.BufferedImage;

public class AbsoluteImageReference
extends AbstractImageReference {
    private final IHierarchicalContentNode contentNode;
    private final String uniqueId;
    private final RequestedImageSize imageSize;
    private final ImageTransfomationFactories imageTransfomationFactories;
    private final ImageLibraryInfo imageLibraryOrNull;
    private BufferedImage image;
    private ChannelColorRGB channelColor;
    private String singleChannelTransformationCodeOrNull;
    private final String channelCodeOrNull;

    public AbsoluteImageReference(IHierarchicalContentNode contentNode, String uniqueId, String imageIdOrNull, ColorComponent colorComponentOrNull, RequestedImageSize imageSize, ChannelColorRGB channelColor, ImageTransfomationFactories imageTransfomationFactories, ImageLibraryInfo imageLibraryOrNull, String singleChannelTransformationCodeOrNull, String channelCodeOrNull) {
        super(imageIdOrNull, colorComponentOrNull);
        assert (imageSize != null) : "image size is null";
        assert (imageTransfomationFactories != null) : "imageTransfomationFactories is null";
        this.contentNode = contentNode;
        this.uniqueId = uniqueId;
        this.imageSize = imageSize;
        this.channelColor = channelColor;
        this.imageTransfomationFactories = imageTransfomationFactories;
        this.imageLibraryOrNull = imageLibraryOrNull;
        this.singleChannelTransformationCodeOrNull = singleChannelTransformationCodeOrNull;
        this.channelCodeOrNull = channelCodeOrNull;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public IHierarchicalContentNode tryGetRawContent() {
        if (this.tryGetColorComponent() == null && this.tryGetImageID() == null) {
            return this.contentNode;
        }
        return null;
    }

    public IHierarchicalContentNode tryGetRawContentForOriginalImage() {
        if (this.tryGetColorComponent() == null && this.tryGetImageID() == null && !this.getRequestedSize().isThumbnailRequired()) {
            return this.contentNode;
        }
        return null;
    }

    public BufferedImage getUnchangedImage() {
        if (this.image == null) {
            this.image = Utils.loadUnchangedImage(this.contentNode, this.tryGetImageID(), this.imageLibraryOrNull);
        }
        return this.image;
    }

    public Size getUnchangedImageSize() {
        if (this.image != null) {
            return new Size(this.image.getWidth(), this.image.getHeight());
        }
        return Utils.loadUnchangedImageSize(this.contentNode, this.tryGetImageID(), this.imageLibraryOrNull);
    }

    public Integer getColorDepth() {
        if (this.image != null) {
            return this.image.getColorModel().getPixelSize();
        }
        return Utils.loadUnchangedImageColorDepth(this.contentNode, this.channelCodeOrNull, this.imageLibraryOrNull);
    }

    public RequestedImageSize getRequestedSize() {
        return this.imageSize;
    }

    public ImageTransfomationFactories getImageTransfomationFactories() {
        return this.imageTransfomationFactories;
    }

    public ChannelColorRGB getChannelColor() {
        return this.channelColor;
    }

    public String tryGetSingleChannelTransformationCode() {
        return this.singleChannelTransformationCodeOrNull;
    }

    public String tryGetChannelCode() {
        return this.channelCodeOrNull;
    }

    public AbsoluteImageReference createWithoutColorComponent() {
        ColorComponent colorComponent = null;
        return new AbsoluteImageReference(this.contentNode, this.uniqueId, this.tryGetImageID(), colorComponent, this.imageSize, this.channelColor, this.imageTransfomationFactories, this.imageLibraryOrNull, this.singleChannelTransformationCodeOrNull, null);
    }
}

