/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.etlserver.plugins.DeleteFromExternalDBMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public class DeleteFromImagingDBMaintenanceTask
extends DeleteFromExternalDBMaintenanceTask {
    private static Set<TechId> getContainers(Connection c, List<DeletedDataSet> deletedDataSets) throws SQLException {
        ResultSet result = c.createStatement().executeQuery(String.format("SELECT DISTINCT CONTAINER_DATASET_ID FROM IMAGE_ZOOM_LEVELS where PHYSICAL_DATASET_PERM_ID in (%s)", DeleteFromImagingDBMaintenanceTask.joinIds(deletedDataSets)));
        return DeleteFromImagingDBMaintenanceTask.getContainersSet(result);
    }

    private static Set<TechId> getContainersSet(ResultSet result) throws SQLException {
        HashSet<TechId> containers = new HashSet<TechId>();
        while (result.next()) {
            long techId = result.getLong("CONTAINER_DATASET_ID");
            containers.add(new TechId(Long.valueOf(techId)));
        }
        return containers;
    }

    private static Set<TechId> getRemainingZoomLevels(Connection c, Set<TechId> modifiedContaiers, boolean thumbnails) throws SQLException {
        ResultSet result = c.createStatement().executeQuery(String.format("SELECT CONTAINER_DATASET_ID FROM IMAGE_ZOOM_LEVELS where CONTAINER_DATASET_ID in (%s) AND IS_ORIGINAL = " + (thumbnails ? "FALSE" : "TRUE"), DeleteFromImagingDBMaintenanceTask.joinIds(modifiedContaiers)));
        return DeleteFromImagingDBMaintenanceTask.getContainersSet(result);
    }

    private static String joinIds(Set<TechId> codes) {
        StringBuilder sb = new StringBuilder();
        for (IIdHolder iIdHolder : codes) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("'" + StringEscapeUtils.escapeSql((String)iIdHolder.getId().toString()) + "'");
        }
        String string = sb.toString();
        return string;
    }

    private static Set<TechId> getMissingIds(Set<TechId> allIds, Set<TechId> selectedIds) {
        HashSet<TechId> missingIds = new HashSet<TechId>();
        for (TechId techId : allIds) {
            if (selectedIds.contains(techId)) continue;
            missingIds.add(techId);
        }
        return missingIds;
    }

    private static void clearAcquiredImages(Connection c, Set<TechId> ids, boolean isThumbnail) throws SQLException {
        String joinedIds = DeleteFromImagingDBMaintenanceTask.joinIds(ids);
        String statement = String.format("UPDATE ACQUIRED_IMAGES SET %s = NULL   WHERE CHANNEL_STACK_ID IN (SELECT ID FROM CHANNEL_STACKS WHERE DS_ID IN (%s))     OR CHANNEL_ID IN (SELECT ID FROM CHANNELS WHERE DS_ID IN (%s))", isThumbnail ? "THUMBNAIL_ID" : "IMG_ID", joinedIds, joinedIds);
        c.createStatement().execute(statement);
    }

    protected void deleteDatasets(List<DeletedDataSet> deletedDataSets) throws SQLException {
        Set<TechId> containers;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Synchronizing deletions of %d datasets with the database.", deletedDataSets.size()));
        }
        if ((containers = DeleteFromImagingDBMaintenanceTask.getContainers(this.connection, deletedDataSets)).size() > 0) {
            this.connection.createStatement().execute(String.format("DELETE FROM IMAGE_ZOOM_LEVELS WHERE PHYSICAL_DATASET_PERM_ID IN (%s)", DeleteFromImagingDBMaintenanceTask.joinIds(deletedDataSets)));
            Set<TechId> thumbnailsToDelete = DeleteFromImagingDBMaintenanceTask.getMissingIds(containers, DeleteFromImagingDBMaintenanceTask.getRemainingZoomLevels(this.connection, containers, true));
            Set<TechId> originalImagesToDelete = DeleteFromImagingDBMaintenanceTask.getMissingIds(containers, DeleteFromImagingDBMaintenanceTask.getRemainingZoomLevels(this.connection, containers, false));
            if (thumbnailsToDelete.size() > 0) {
                DeleteFromImagingDBMaintenanceTask.clearAcquiredImages(this.connection, thumbnailsToDelete, true);
            }
            if (originalImagesToDelete.size() > 0) {
                DeleteFromImagingDBMaintenanceTask.clearAcquiredImages(this.connection, originalImagesToDelete, false);
            }
        }
        String[] stringArray = this.dataSetTableNames;
        int n = this.dataSetTableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String dataSetTableName = stringArray[n2];
            this.connection.createStatement().execute(String.format("DELETE FROM " + dataSetTableName.trim() + " WHERE " + this.permIDColumn + " IN (%s)", DeleteFromImagingDBMaintenanceTask.joinIds(deletedDataSets)));
            ++n2;
        }
    }
}

