/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageFileExtractor;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageStorageProcessor;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.ImageFileExtractionResult;
import ch.systemsx.cisd.openbis.dss.etl.MicroscopyImageDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.MicroscopyImageDatasetUploader;
import ch.systemsx.cisd.openbis.dss.etl.PlateStorageProcessor;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ChannelDescription;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

public class MicroscopyBlackboxSeriesStorageProcessor
extends AbstractImageStorageProcessor {
    private static final String DEFAULT_CHANNEL_CODE = "DEFAULT";
    private static final String DEFAULT_CHANNEL_LABEL = "Default";
    private static final Location DEFAULT_TILE = new Location(1, 1);
    private static final Geometry DEFAULT_TILE_GEOMETRY = new Geometry(1, 1);
    private static final List<ChannelDescription> DEFAULT_CHANNELS = Arrays.asList(new ChannelDescription("DEFAULT", "Default"));

    public MicroscopyBlackboxSeriesStorageProcessor(Properties properties) {
        super(new BlackboxSeriesImageFileExtractor(properties), properties);
    }

    @Override
    protected void storeInDatabase(IImagingQueryDAO dao, PlateStorageProcessor.ImageDatasetOwnerInformation dataSetInformation, ImageFileExtractionResult extractedImages, boolean thumbnailsOnly) {
        List<AcquiredSingleImage> images = extractedImages.getImages();
        this.setSeriesNumber(images);
        MicroscopyImageDatasetInfo dataset = this.createMicroscopyImageDatasetInfo(dataSetInformation, images, extractedImages.getTileGeometry(), extractedImages.tryGetImageLibrary());
        MicroscopyImageDatasetUploader.upload(dao, dataset, images, extractedImages.getChannels());
    }

    private void setSeriesNumber(List<AcquiredSingleImage> images) {
        Collections.sort(images, this.createPathComparator());
        int seriesNumber = 1;
        for (AcquiredSingleImage image : images) {
            image.setSeriesNumber(seriesNumber++);
        }
    }

    private Comparator<AcquiredSingleImage> createPathComparator() {
        return new Comparator<AcquiredSingleImage>(){

            @Override
            public int compare(AcquiredSingleImage o1, AcquiredSingleImage o2) {
                return this.getPath(o1).compareTo(this.getPath(o2));
            }

            private String getPath(AcquiredSingleImage o1) {
                return o1.getImageReference().getImageRelativePath();
            }
        };
    }

    private MicroscopyImageDatasetInfo createMicroscopyImageDatasetInfo(PlateStorageProcessor.ImageDatasetOwnerInformation dataSetInformation, List<AcquiredSingleImage> images, Geometry tileGeometry, ImageLibraryInfo imageLibraryInfoOrNull) {
        boolean hasImageSeries = MicroscopyBlackboxSeriesStorageProcessor.hasImageSeries(images);
        ImageDatasetInfo imageDatasetInfo = new ImageDatasetInfo(tileGeometry.getRows(), tileGeometry.getColumns(), hasImageSeries, imageLibraryInfoOrNull, dataSetInformation.getImageZoomLevels());
        return new MicroscopyImageDatasetInfo(dataSetInformation.getDataSetCode(), imageDatasetInfo);
    }

    @Override
    protected boolean validateImages(PlateStorageProcessor.DatasetOwnerInformation dataSetInformation, IMailClient mailClient, File incomingDataSetDirectory, ImageFileExtractionResult extractionResult) {
        return true;
    }

    private static class BlackboxSeriesImageFileExtractor
    extends AbstractImageFileExtractor {
        protected BlackboxSeriesImageFileExtractor(Properties properties) {
            super(DEFAULT_CHANNELS, DEFAULT_TILE_GEOMETRY, true, properties);
        }

        @Override
        protected ImageFileInfo tryExtractImageInfo(File imageFile, File incomingDataSetDirectory, SampleIdentifier datasetSample) {
            String imageRelativePath = BlackboxSeriesImageFileExtractor.getRelativeImagePath(incomingDataSetDirectory, imageFile);
            ImageFileInfo info = new ImageFileInfo(MicroscopyBlackboxSeriesStorageProcessor.DEFAULT_CHANNEL_CODE, DEFAULT_TILE.getY(), DEFAULT_TILE.getX(), imageRelativePath);
            return info;
        }
    }
}

