/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageFileExtractor;
import ch.systemsx.cisd.openbis.dss.etl.UnparsedImageFileInfoLexer;
import ch.systemsx.cisd.openbis.dss.etl.dto.UnparsedImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.util.Properties;

public class MicroscopyImageFileExtractor
extends AbstractImageFileExtractor {
    public MicroscopyImageFileExtractor(Properties properties) {
        super(properties, true);
        if (this.tileMapperOrNull == null) {
            throw new ConfigurationFailureException("Tile mapping property not defined: tile_mapping");
        }
    }

    @Override
    protected ImageFileInfo tryExtractImageInfo(File imageFile, File incomingDataSetDirectory, SampleIdentifier datasetSample) {
        UnparsedImageFileInfo unparsedInfo = UnparsedImageFileInfoLexer.tryExtractMicroscopyImageFileInfo(imageFile, incomingDataSetDirectory);
        if (unparsedInfo == null) {
            return null;
        }
        Location tileLocation = null;
        Integer tileNumber = MicroscopyImageFileExtractor.tryAsInt(unparsedInfo.getTileLocationToken());
        if (tileNumber != null) {
            tileLocation = this.tryGetTileLocation(tileNumber);
        }
        if (tileLocation == null) {
            operationLog.info((Object)("Cannot extract tile location (a.k.a. tile/field/side) from token " + unparsedInfo.getTileLocationToken()));
            return null;
        }
        String channelCode = CodeNormalizer.normalize((String)unparsedInfo.getChannelToken());
        String imageRelativePath = MicroscopyImageFileExtractor.getRelativeImagePath(incomingDataSetDirectory, imageFile);
        ImageFileInfo info = new ImageFileInfo(channelCode, tileLocation.getY(), tileLocation.getX(), imageRelativePath);
        Float timepointOrNull = MicroscopyImageFileExtractor.tryAsFloat(unparsedInfo.getTimepointToken());
        info.setTimepoint(timepointOrNull);
        Float depthOrNull = MicroscopyImageFileExtractor.tryAsFloat(unparsedInfo.getDepthToken());
        info.setDepth(depthOrNull);
        Integer seriesNumberOrNull = MicroscopyImageFileExtractor.tryAsInt(unparsedInfo.getSeriesNumberToken());
        info.setSeriesNumber(seriesNumberOrNull);
        return info;
    }
}

