/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.custom.incell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IncellImageMetadataParser
extends DefaultHandler {
    private static final String LEVEL1_TAG = "ImageStack";
    private static final String LEVEL2_TAG = "AutoLeadAcquisitionProtocol";
    private static final String WAVELENGTHS_TAG = "Wavelengths";
    private static final String WAVELENGTH_TAG = "Wavelength";
    private static final String EMISSION_FILTER_TAG = "EmissionFilter";
    private static final String CHANNEL_CODE_ATTR = "name";
    private static final String CHANNEL_WAVELENGTH_ATTR = "wavelength";
    private State state = State.INIT;
    private List<String> channelCodes = new ArrayList<String>();
    private List<String> channelWavelengths = new ArrayList<String>();

    public IncellImageMetadataParser(String fileName) throws ParserConfigurationException, SAXException, IOException {
        assert (fileName != null);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = spf.newSAXParser();
        sp.parse(fileName, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case INIT: {
                if (!LEVEL1_TAG.equals(qName)) break;
                this.state = State.LEVEL1;
                break;
            }
            case LEVEL1: {
                if (!LEVEL2_TAG.equals(qName)) break;
                this.state = State.LEVEL2;
                break;
            }
            case LEVEL2: {
                if (!WAVELENGTHS_TAG.equals(qName)) break;
                this.state = State.WAVELENGTHS;
                break;
            }
            case WAVELENGTHS: {
                if (!WAVELENGTH_TAG.equals(qName)) break;
                this.state = State.WAVELENGTH;
                break;
            }
            case WAVELENGTH: {
                if (!EMISSION_FILTER_TAG.equals(qName)) break;
                this.channelCodes.add(this.parseChannelCode(attributes));
                this.channelWavelengths.add(this.parseChannelWavelength(attributes));
                this.state = State.EMISSION_FILTER;
                break;
            }
            case EMISSION_FILTER: {
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (EMISSION_FILTER_TAG.equals(qName) && this.state == State.EMISSION_FILTER) {
            this.state = State.WAVELENGTH;
        }
        if (WAVELENGTH_TAG.equals(qName) && this.state == State.WAVELENGTH) {
            this.state = State.WAVELENGTHS;
        }
        if (WAVELENGTHS_TAG.equals(qName) && this.state == State.WAVELENGTHS) {
            this.state = State.FINISHED;
        }
    }

    public String[] getChannelCodes() {
        return this.channelCodes.toArray(new String[0]);
    }

    public int[] getChannelWavelengths() {
        int[] wavelengths = new int[this.channelWavelengths.size()];
        int i = 0;
        while (i < wavelengths.length) {
            wavelengths[i] = Integer.parseInt(this.channelWavelengths.get(i));
            ++i;
        }
        return wavelengths;
    }

    private String parseChannelCode(Attributes attributes) {
        return this.parseAttribute(CHANNEL_CODE_ATTR, attributes);
    }

    private String parseChannelWavelength(Attributes attributes) {
        return this.parseAttribute(CHANNEL_WAVELENGTH_ATTR, attributes);
    }

    private String parseAttribute(String attrName, Attributes attributes) {
        String attrValue = attributes.getValue(attrName);
        return StringUtils.trimToEmpty((String)attrValue);
    }

    private static enum State {
        INIT,
        LEVEL1,
        LEVEL2,
        WAVELENGTHS,
        WAVELENGTH,
        EMISSION_FILTER,
        FINISHED;

    }
}

