/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api;

import ch.systemsx.cisd.common.image.WavelengthColor;
import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColor;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorRGB;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformation;
import java.awt.Color;
import java.io.Serializable;

public class Channel
extends AbstractHashable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String label;
    private String description;
    private Integer wavelength;
    private ChannelColorRGB channelColorOrNull;
    private ImageTransformation[] availableTransformations = new ImageTransformation[0];

    public Channel(String code, String label) {
        this(code, label, (ChannelColorRGB)null);
    }

    public Channel(String code, String label, ChannelColor channelColorOrNull) {
        this(code, label, Channel.convertColor(channelColorOrNull));
    }

    public Channel(String code, String label, ChannelColorRGB channelColorOrNull) {
        assert (code != null) : "code is null";
        assert (label != null) : "label is null";
        this.label = label;
        this.code = code;
        this.channelColorOrNull = channelColorOrNull;
    }

    private static ChannelColorRGB convertColor(ChannelColor plainChannelColorOrNull) {
        if (plainChannelColorOrNull == null) {
            return null;
        }
        return plainChannelColorOrNull.getRGB();
    }

    public String getCode() {
        return this.code;
    }

    public String tryGetDescription() {
        return this.description;
    }

    public Integer tryGetWavelength() {
        return this.wavelength;
    }

    public String getLabel() {
        return this.label;
    }

    public ChannelColorRGB tryGetChannelColor() {
        return this.channelColorOrNull;
    }

    public ImageTransformation[] getAvailableTransformations() {
        return this.availableTransformations;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setWavelength(Integer wavelength) {
        this.wavelength = wavelength;
    }

    public void setWavelengthAndColor(Integer wavelength) {
        this.wavelength = wavelength;
        Color color = WavelengthColor.getColorForWavelength((int)wavelength);
        this.setChannelColorRGB(this.convertColor(color));
    }

    private ChannelColorRGB convertColor(Color color) {
        return new ChannelColorRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setChannelColor(ChannelColor channelColor) {
        this.channelColorOrNull = Channel.convertColor(channelColor);
    }

    public void setChannelColorRGB(ChannelColorRGB channelColor) {
        this.channelColorOrNull = channelColor;
    }

    public void setAvailableTransformations(ImageTransformation[] transformations) {
        this.availableTransformations = transformations == null ? new ImageTransformation[0] : transformations;
    }
}

