/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api;

import java.io.Serializable;

public class ChannelColorRGB
implements Serializable {
    private static final long serialVersionUID = 35L;
    private int r;
    private int g;
    private int b;

    private ChannelColorRGB() {
    }

    public ChannelColorRGB(int r, int g, int b) {
        assert (r >= 0 && r <= 255) : "invalid color " + r;
        assert (g >= 0 && g <= 255) : "invalid color " + g;
        assert (b >= 0 && b <= 255) : "invalid color " + b;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public String toString() {
        return "Color(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.b;
        result = 31 * result + this.g;
        result = 31 * result + this.r;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelColorRGB other = (ChannelColorRGB)obj;
        if (this.b != other.b) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        return this.r == other.r;
    }
}

