/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v1.OriginalDataStorageFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ImageStorageConfiguraton
extends AbstractHashable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ThumbnailsStorageFormat> thumbnailsStorageFormatsList = new ArrayList<ThumbnailsStorageFormat>();
    private ch.systemsx.cisd.openbis.dss.etl.dto.api.OriginalDataStorageFormat originalDataStorageFormat = ch.systemsx.cisd.openbis.dss.etl.dto.api.OriginalDataStorageFormat.UNCHANGED;
    private Boolean storeChannelsOnExperimentLevelOrNull = null;
    private IImageTransformerFactory imageTransformerFactoryOrNull;
    private ImageLibraryInfo imageLibraryOrNull = null;

    public static ImageStorageConfiguraton createDefault() {
        return new ImageStorageConfiguraton();
    }

    public List<ThumbnailsStorageFormat> getThumbnailsStorageFormat() {
        return this.thumbnailsStorageFormatsList;
    }

    public void setThumbnailsStorageFormat(ThumbnailsStorageFormat thumbnailsStorageFormatOrNull) {
        this.thumbnailsStorageFormatsList.clear();
        this.addThumbnailsStorageFormat(thumbnailsStorageFormatOrNull);
    }

    public void addThumbnailsStorageFormat(ThumbnailsStorageFormat thumbnailsStorageFormatOrNull) {
        if (thumbnailsStorageFormatOrNull != null) {
            this.thumbnailsStorageFormatsList.add(thumbnailsStorageFormatOrNull);
        }
    }

    public void switchOnThumbnailsGeneration() {
        this.thumbnailsStorageFormatsList.clear();
        this.thumbnailsStorageFormatsList.add(new ThumbnailsStorageFormat());
    }

    public ch.systemsx.cisd.openbis.dss.etl.dto.api.OriginalDataStorageFormat getOriginalDataStorageFormat() {
        return this.originalDataStorageFormat;
    }

    public void setOriginalDataStorageFormat(ch.systemsx.cisd.openbis.dss.etl.dto.api.OriginalDataStorageFormat originalDataStorageFormat) {
        this.originalDataStorageFormat = originalDataStorageFormat;
    }

    public void setOriginalDataStorageFormat(OriginalDataStorageFormat originalDataStorageFormat) {
        this.originalDataStorageFormat = originalDataStorageFormat.getIndependentOriginalDataStorageFormat();
    }

    public void setStoreChannelsOnExperimentLevel(boolean storeChannelsOnExperimentLevel) {
        this.storeChannelsOnExperimentLevelOrNull = storeChannelsOnExperimentLevel;
    }

    public Boolean getStoreChannelsOnExperimentLevel() {
        return this.storeChannelsOnExperimentLevelOrNull;
    }

    public IImageTransformerFactory getImageTransformerFactory() {
        return this.imageTransformerFactoryOrNull;
    }

    public void setImageTransformerFactory(IImageTransformerFactory transformerFactory) {
        this.imageTransformerFactoryOrNull = transformerFactory;
    }

    public void setImageLibrary(ImageLibraryInfo imageLibrary) {
        this.imageLibraryOrNull = imageLibrary;
    }

    public ImageLibraryInfo tryGetImageLibrary() {
        return this.imageLibraryOrNull;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        if (this.originalDataStorageFormat != ch.systemsx.cisd.openbis.dss.etl.dto.api.OriginalDataStorageFormat.UNCHANGED) {
            ImageStorageConfiguraton.appendNameAndObject(buffer, "original data storage format", this.originalDataStorageFormat.toString());
        }
        if (this.thumbnailsStorageFormatsList.size() > 0) {
            for (ThumbnailsStorageFormat thumbnailsStorageFormat : this.thumbnailsStorageFormatsList) {
                ImageStorageConfiguraton.appendNameAndObject(buffer, "thumbnails", thumbnailsStorageFormat.toString());
            }
        }
        if (this.storeChannelsOnExperimentLevelOrNull != null) {
            ImageStorageConfiguraton.appendNameAndObject(buffer, "store channels on experiment level", this.storeChannelsOnExperimentLevelOrNull);
        }
        if (this.imageTransformerFactoryOrNull != null) {
            ImageStorageConfiguraton.appendNameAndObject(buffer, "image transformation", "present");
        }
        if (this.imageLibraryOrNull != null) {
            ImageStorageConfiguraton.appendNameAndObject(buffer, "image library", this.imageLibraryOrNull.toString());
        }
        return buffer.toString();
    }

    protected static final void appendNameAndObject(StringBuilder buffer, String name, Object object) {
        if (object != null) {
            buffer.append(name).append("::").append(object).append(";");
        }
    }
}

