/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.impl;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorComponent;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageStorageConfiguraton;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ToStringUtil;
import java.io.Serializable;
import java.util.List;

public class ImageDataSetStructure
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ImageFileInfo> images;
    private List<Channel> channels;
    private List<ChannelColorComponent> channelColorComponentsOrNull;
    private int tileRowsNumber;
    private int tileColumnsNumber;
    private ImageStorageConfiguraton imageStorageConfiguratonOrNull;

    public int getTileRowsNumber() {
        return this.tileRowsNumber;
    }

    public int getTileColumnsNumber() {
        return this.tileColumnsNumber;
    }

    public List<ImageFileInfo> getImages() {
        return this.images;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public List<ChannelColorComponent> getChannelColorComponents() {
        return this.channelColorComponentsOrNull;
    }

    public ImageStorageConfiguraton getImageStorageConfiguraton() {
        return this.imageStorageConfiguratonOrNull;
    }

    public boolean areThumbnailsGenerated() {
        return this.getImageStorageConfiguraton().getThumbnailsStorageFormat().size() > 0;
    }

    public void setTileGeometry(int tileRowsNumber, int tileColumnsNumber) {
        this.tileRowsNumber = tileRowsNumber;
        this.tileColumnsNumber = tileColumnsNumber;
    }

    public void setImages(List<ImageFileInfo> images) {
        this.images = images;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public void setChannels(List<Channel> channels, List<ChannelColorComponent> channelColorComponents) {
        if (channels.size() != channelColorComponents.size()) {
            throw new IllegalArgumentException("There should be exactly one color component for each channel!");
        }
        this.channels = channels;
        this.channelColorComponentsOrNull = channelColorComponents;
    }

    public void setImageStorageConfiguraton(ImageStorageConfiguraton imageStorageConfiguratonOrNull) {
        this.imageStorageConfiguratonOrNull = imageStorageConfiguratonOrNull;
    }

    public boolean isValid() {
        return this.tileRowsNumber > 0 && this.tileColumnsNumber > 0 && this.channels != null && this.images != null;
    }

    public void validateImageRepresentationGenerationParameters(ImageDataSetInformation imageDataSetInformation) {
        List<ThumbnailsStorageFormat> storageFormats = this.getImageStorageConfiguraton().getThumbnailsStorageFormat();
        int originalWidth = imageDataSetInformation.getMaximumImageWidth();
        int originalHeight = imageDataSetInformation.getMaximumImageHeight();
        boolean foundErrors = false;
        StringBuilder errorSb = new StringBuilder();
        for (ThumbnailsStorageFormat storageFormat : storageFormats) {
            if (storageFormat.isAllowEnlarging()) continue;
            int representationWidth = storageFormat.getMaxWidth();
            int representationHeight = storageFormat.getMaxHeight();
            if (representationWidth <= originalWidth && representationHeight <= originalHeight) continue;
            foundErrors = true;
            errorSb.append("Requested representation size ");
            errorSb.append(representationWidth);
            errorSb.append("x");
            errorSb.append(representationHeight);
            errorSb.append(" is larger than original size ");
            errorSb.append(originalWidth);
            errorSb.append("x");
            errorSb.append(originalHeight);
            errorSb.append("; enlarging of images has been explicitly disabled");
            errorSb.append("\n");
        }
        if (foundErrors) {
            throw new UserFailureException(errorSb.toString());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        ToStringUtil.appendNameAndObject((StringBuilder)buffer, (String)"config", (Object)this.imageStorageConfiguratonOrNull);
        ToStringUtil.appendNameAndObject((StringBuilder)buffer, (String)"tile", (Object)(String.valueOf(this.tileRowsNumber) + "x" + this.tileColumnsNumber));
        ToStringUtil.appendNameAndObject((StringBuilder)buffer, (String)"channels", (Object)CollectionUtils.abbreviate(this.channels, (int)-1));
        ToStringUtil.appendNameAndObject((StringBuilder)buffer, (String)"number of images", (Object)this.images.size());
        return buffer.toString();
    }
}

