/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.impl;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSet;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureVectorDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.IFeatureVectorDataSet;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.impl.FeatureVectorDataSet;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import java.io.File;

public class FeatureVectorContainerDataSet
extends DataSet<DataSetInformation>
implements IFeatureVectorDataSet {
    private FeatureVectorDataSet originalDataset;

    public FeatureVectorContainerDataSet(DataSetRegistrationDetails<? extends DataSetInformation> registrationDetails, File dataSetFolder, IEncapsulatedOpenBISService service) {
        super(registrationDetails, dataSetFolder, service);
    }

    public IDataSet getOriginalDataset() {
        return this.originalDataset;
    }

    public void setOriginalDataSet(FeatureVectorDataSet mainDataSet) {
        this.originalDataset = mainDataSet;
    }

    @Override
    public void setAnalysisProcedure(String analysisProcedure) {
        this.getRegistrationDetails().getDataSetInformation().getDataSetProperties().add(new NewProperty("$ANALYSIS_PROCEDURE", analysisProcedure));
    }

    public void setSample(ISampleImmutable sampleOrNull) {
        super.setSample(sampleOrNull);
        if (this.originalDataset != null) {
            this.originalDataset.setSample(sampleOrNull);
            ((FeatureVectorDataSetInformation)this.originalDataset.getRegistrationDetails().getDataSetInformation()).setLinkSample(false);
        }
    }

    public void setExperiment(IExperimentImmutable experimentOrNull) {
        super.setExperiment(experimentOrNull);
        if (this.originalDataset != null) {
            this.originalDataset.setExperiment(experimentOrNull);
        }
    }

    public void setPropertyValue(String propertyCode, String propertyValue) {
        this.getRegistrationDetails().setPropertyValue(propertyCode, propertyValue);
    }

    public static String getContainerAnalysisType(String dataSetTypeCode) {
        if (!FeatureVectorContainerDataSet.isHCSAnalysisDataSetType(dataSetTypeCode)) {
            throw UserFailureException.fromTemplate((String)"Feature vector data set type should conform to the HCS_ANALYSIS_* pattern, but was %s", (Object[])new Object[]{dataSetTypeCode});
        }
        String containerDatasetTypeCode = "HCS_ANALYSIS_CONTAINER" + dataSetTypeCode.substring("HCS_ANALYSIS".length());
        return containerDatasetTypeCode;
    }

    private static boolean isHCSAnalysisDataSetType(String mainDatasetTypeCode) {
        String prefix = "HCS_ANALYSIS";
        if (mainDatasetTypeCode.startsWith(prefix)) {
            if (mainDatasetTypeCode.contains("_CONTAINER")) {
                throw UserFailureException.fromTemplate((String)"The specified analysis dataset type '%s' should not be of container type, but contains '%s' in the type code.", (Object[])new Object[]{mainDatasetTypeCode, "_CONTAINER"});
            }
            return true;
        }
        return false;
    }

    public void setDataSetType(String dataSetTypeCode) {
        this.originalDataset.setDataSetType(dataSetTypeCode);
        super.setDataSetType(FeatureVectorContainerDataSet.getContainerAnalysisType(dataSetTypeCode));
    }
}

