/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.featurevector;

import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureDefinition;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CanonicalFeatureVector;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CsvFeatureVectorParser;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import java.util.ArrayList;
import java.util.List;

public class CsvToCanonicalFeatureVector {
    private final CsvFeatureVectorParser parser;
    private final Geometry plateGeometry;

    public CsvToCanonicalFeatureVector(DatasetFileLines fileLines, CsvFeatureVectorParser.CsvFeatureVectorParserConfiguration config, Geometry plateGeometry) {
        this(fileLines, config, plateGeometry.getNumberOfRows(), plateGeometry.getNumberOfColumns());
    }

    public CsvToCanonicalFeatureVector(DatasetFileLines fileLines, CsvFeatureVectorParser.CsvFeatureVectorParserConfiguration config, int maxRow, int maxCol) {
        this.parser = new CsvFeatureVectorParser(fileLines, config);
        this.plateGeometry = Geometry.createFromRowColDimensions(maxRow, maxCol);
    }

    public List<CanonicalFeatureVector> convert() {
        List<FeatureDefinition> featureDefinitions = this.parser.parse();
        ArrayList<CanonicalFeatureVector> result = new ArrayList<CanonicalFeatureVector>();
        for (FeatureDefinition featureDefinition : featureDefinitions) {
            result.add(featureDefinition.getCanonicalFeatureVector(this.plateGeometry));
        }
        return result;
    }
}

