/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.images;

import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;

class ColorComponentImageChannelMerger {
    ColorComponentImageChannelMerger() {
    }

    public static BufferedImage mergeByExtractingComponents(BufferedImage[] images, ColorComponent[] colorComponents) {
        assert (images.length > 1) : "more than 1 image expected, but found: " + images.length;
        BufferedImage newImage = ColorComponentImageChannelMerger.createNewRGBImage(images[0]);
        int width = newImage.getWidth();
        int height = newImage.getHeight();
        int[] colorBuffer = new int[4];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int mergedRGB = ColorComponentImageChannelMerger.mergeRGBColor(images, colorComponents, x, y, colorBuffer);
                newImage.setRGB(x, y, mergedRGB);
                ++x;
            }
            ++y;
        }
        return newImage;
    }

    private static int mergeRGBColor(BufferedImage[] images, ColorComponent[] colorComponents, int x, int y, int[] colorBuffer) {
        Arrays.fill(colorBuffer, 0);
        int index = 0;
        while (index < images.length) {
            int rgb = images[index].getRGB(x, y);
            Color singleColor = new Color(rgb, true);
            ColorComponentImageChannelMerger.setColorComponents(colorBuffer, singleColor, colorComponents[index]);
            colorBuffer[3] = Math.max(colorBuffer[3], singleColor.getAlpha());
            ++index;
        }
        return ColorComponentImageChannelMerger.asRGB(colorBuffer);
    }

    private static void setColorComponents(int[] colorBuffer, Color singleColor, ColorComponent colorComponent) {
        int index = ColorComponentImageChannelMerger.getColorComponentIndex(colorComponent);
        colorBuffer[index] = colorComponent.getComponent(singleColor);
    }

    private static int getColorComponentIndex(ColorComponent colorComponent) {
        switch (colorComponent) {
            case RED: {
                return 0;
            }
            case GREEN: {
                return 1;
            }
            case BLUE: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown color " + (Object)((Object)colorComponent));
    }

    private static int asRGB(int[] rgb) {
        return new Color(rgb[0], rgb[1], rgb[2], rgb[3]).getRGB();
    }

    private static BufferedImage createNewRGBImage(BufferedImage bufferedImage) {
        return new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
    }
}

