/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.images;

import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageGenerationDescription;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelTransformationEnrichedDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepresentationUtil {
    public static ImageRepresentationFormat tryGetRepresentationFormat(ImageGenerationDescription params) {
        if (params.tryGetImageChannels() == null) {
            return null;
        }
        if (params.getOverlayChannels() != null && params.getOverlayChannels().size() > 0) {
            return null;
        }
        String code = params.tryGetImageChannels().getDatasetCode();
        if (code == null) {
            return null;
        }
        IImagingReadonlyQueryDAO dao = DssScreeningUtils.getQuery();
        ImgImageDatasetDTO imageDataSet = dao.tryGetImageDatasetByPermId(code);
        if (imageDataSet == null) {
            return null;
        }
        List<ImageRepresentationFormat> representations = RepresentationUtil.getImageRepresentationFormats(imageDataSet, dao);
        for (ImageRepresentationFormat representation : representations) {
            if (!RepresentationUtil.representationMatchesDescription(representation, params)) continue;
            return representation;
        }
        return null;
    }

    static boolean representationMatchesDescription(ImageRepresentationFormat format, ImageGenerationDescription params) {
        if (!RepresentationUtil.sizeMatches(format, params)) {
            return false;
        }
        List<String> channels = params.tryGetImageChannels().getChannelCodes(null);
        if (channels == null || channels.size() != 1) {
            return false;
        }
        String channel = channels.get(0);
        List<ImageRepresentationFormat.ImageRepresentationTransformation> existingTransformations = format.getTransformations();
        for (ImageRepresentationFormat.ImageRepresentationTransformation t : existingTransformations) {
            if (!t.getChannelCode().equals(channel)) continue;
            return t.getTransformationCode().equals(params.tryGetSingleChannelTransformationCode());
        }
        return params.tryGetSingleChannelTransformationCode() == null;
    }

    static boolean sizeMatches(ImageRepresentationFormat format, ImageGenerationDescription params) {
        if (params.tryGetThumbnailSize() != null) {
            if (format.isOriginal()) {
                return false;
            }
            return format.getWidth().intValue() == params.tryGetThumbnailSize().getWidth() && format.getHeight().intValue() == params.tryGetThumbnailSize().getHeight();
        }
        return format.isOriginal();
    }

    public static List<ImageRepresentationFormat> getImageRepresentationFormats(ImgImageDatasetDTO imageDataSet, IImagingReadonlyQueryDAO dao) {
        List<ImgImageZoomLevelDTO> zoomLevels = dao.listImageZoomLevels(imageDataSet.getId());
        List<ImgImageZoomLevelTransformationEnrichedDTO> zoomLevelsTransformations = dao.listImageZoomLevelTransformations(imageDataSet.getId());
        return RepresentationUtil.convertZoomLevelsToRepresentationFormats(imageDataSet.getPermId(), zoomLevels, zoomLevelsTransformations);
    }

    private static Map<String, List<ImageRepresentationFormat.ImageRepresentationTransformation>> mapTransformationsPerPhysicallDataSets(List<ImgImageZoomLevelTransformationEnrichedDTO> enrichedTransformations) {
        HashMap<String, List<ImageRepresentationFormat.ImageRepresentationTransformation>> transformations = new HashMap<String, List<ImageRepresentationFormat.ImageRepresentationTransformation>>();
        if (enrichedTransformations != null) {
            for (ImgImageZoomLevelTransformationEnrichedDTO transformation : enrichedTransformations) {
                ArrayList<ImageRepresentationFormat.ImageRepresentationTransformation> transformationsPerDataSet = (ArrayList<ImageRepresentationFormat.ImageRepresentationTransformation>)transformations.get(transformation.getPhysicalDatasetPermId());
                if (transformationsPerDataSet == null) {
                    transformationsPerDataSet = new ArrayList<ImageRepresentationFormat.ImageRepresentationTransformation>();
                    transformations.put(transformation.getPhysicalDatasetPermId(), transformationsPerDataSet);
                }
                transformationsPerDataSet.add(new ImageRepresentationFormat.ImageRepresentationTransformation(transformation.getImageTransformationId(), transformation.getTransformationCode(), transformation.getChannelCode()));
            }
        }
        return transformations;
    }

    private static List<ImageRepresentationFormat> convertZoomLevelsToRepresentationFormats(String dataSetCode, List<ImgImageZoomLevelDTO> zoomLevels, List<ImgImageZoomLevelTransformationEnrichedDTO> transformations) {
        ArrayList<ImageRepresentationFormat> results = new ArrayList<ImageRepresentationFormat>();
        Map<String, List<ImageRepresentationFormat.ImageRepresentationTransformation>> transformationsPerDataSet = RepresentationUtil.mapTransformationsPerPhysicallDataSets(transformations);
        for (ImgImageZoomLevelDTO zoomLevel : zoomLevels) {
            ImageRepresentationFormat result = new ImageRepresentationFormat(dataSetCode, zoomLevel.getId(), zoomLevel.getIsOriginal(), zoomLevel.getWidth(), zoomLevel.getHeight(), zoomLevel.getColorDepth(), zoomLevel.getFileType(), transformationsPerDataSet.get(zoomLevel.getPhysicalDatasetPermId()));
            results.add(result);
        }
        return results;
    }
}

