/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.images.dto;

import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.hcs.Location;

public class ImageChannelStackReference
extends AbstractHashable {
    private final HCSChannelStackByLocationReference hcsRefOrNull;
    private final MicroscopyChannelStackByLocationReference microscopyRefOrNull;
    private final Long idRefOrNull;

    public static final ImageChannelStackReference createHCSFromLocations(Location wellLocation, Location tileLocation) {
        return new ImageChannelStackReference(new HCSChannelStackByLocationReference(wellLocation, tileLocation), null, null);
    }

    public static final ImageChannelStackReference createMicroscopyFromLocations(Location tileLocation) {
        return new ImageChannelStackReference(null, new MicroscopyChannelStackByLocationReference(tileLocation), null);
    }

    public static final ImageChannelStackReference createFromId(long channelStackId) {
        return new ImageChannelStackReference(null, null, channelStackId);
    }

    private ImageChannelStackReference(HCSChannelStackByLocationReference hcsRefOrNull, MicroscopyChannelStackByLocationReference microscopyRefOrNull, Long idRefOrNull) {
        int notNulls = (hcsRefOrNull == null ? 0 : 1) + (microscopyRefOrNull == null ? 0 : 1) + (idRefOrNull == null ? 0 : 1);
        assert (notNulls == 1) : "exactly one channel stack reference should be not null: " + (Object)((Object)hcsRefOrNull) + ", " + (Object)((Object)microscopyRefOrNull) + ", " + idRefOrNull;
        this.hcsRefOrNull = hcsRefOrNull;
        this.microscopyRefOrNull = microscopyRefOrNull;
        this.idRefOrNull = idRefOrNull;
    }

    public Long tryGetChannelStackId() {
        return this.idRefOrNull;
    }

    public HCSChannelStackByLocationReference tryGetHCSChannelStack() {
        return this.hcsRefOrNull;
    }

    public MicroscopyChannelStackByLocationReference tryGetMicroscopyChannelStack() {
        return this.microscopyRefOrNull;
    }

    public String toString() {
        if (this.idRefOrNull != null) {
            return "StackReference{id=" + this.idRefOrNull + "}";
        }
        if (this.microscopyRefOrNull != null) {
            return "StackReference{micStack=" + (Object)((Object)this.microscopyRefOrNull) + "}";
        }
        return "StackReference{hcsStack=" + (Object)((Object)this.hcsRefOrNull) + "}";
    }

    public static final class HCSChannelStackByLocationReference
    extends AbstractHashable {
        protected Location wellLocation;
        protected Location tileLocation;

        public HCSChannelStackByLocationReference(Location wellLocation, Location tileLocation) {
            this.wellLocation = wellLocation;
            this.tileLocation = tileLocation;
        }

        public Location getWellLocation() {
            return this.wellLocation;
        }

        public Location getTileLocation() {
            return this.tileLocation;
        }

        public String toString() {
            return "[well=" + this.wellLocation + ", tile=" + this.tileLocation + "]";
        }
    }

    public static final class MicroscopyChannelStackByLocationReference
    extends AbstractHashable {
        protected Location tileLocation;

        public MicroscopyChannelStackByLocationReference(Location tileLocation) {
            this.tileLocation = tileLocation;
        }

        public Location getTileLocation() {
            return this.tileLocation;
        }

        public String toString() {
            return "[tile=" + this.tileLocation + "]";
        }
    }
}

