/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AggregationService;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.IRowBuilder;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class FeatureListsAggregationServicePlugin
extends AggregationService {
    private static final long serialVersionUID = 35L;

    public FeatureListsAggregationServicePlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot, "feature_lists");
    }

    public TableModel createAggregationReport(Map<String, Object> parameters, DataSetProcessingContext context) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder(true);
        builder.addHeader("name");
        builder.addHeader("value");
        Object datasetDescriptionObject = parameters.get("data-set");
        if (datasetDescriptionObject == null) {
            throw new IllegalArgumentException();
        }
        if (!(datasetDescriptionObject instanceof DatasetDescription)) {
            throw new IllegalArgumentException();
        }
        DatasetDescription datasetDescription = (DatasetDescription)datasetDescriptionObject;
        try {
            IHierarchicalContentNode subDirNode = this.getDataSubDir(context.getHierarchicalContentProvider(), datasetDescription);
            IRowBuilder row = null;
            if (subDirNode.exists() && subDirNode.isDirectory()) {
                for (IHierarchicalContentNode contentNode : subDirNode.getChildNodes()) {
                    if (contentNode.isDirectory()) continue;
                    row = builder.addRow();
                    this.readSingleFeaturesList(row, contentNode);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return builder.getTableModel();
    }

    private void readSingleFeaturesList(IRowBuilder row, IHierarchicalContentNode contentNode) {
        InputStream is = null;
        try {
            try {
                is = contentNode.getInputStream();
                String value = IOUtils.toString((InputStream)is);
                row.setCell("name", contentNode.getName());
                row.setCell("value", value);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
        }
    }
}

