/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.screening.shared.api.internal;

import ch.systemsx.cisd.common.multiplexer.BatchHandlerAbstract;
import ch.systemsx.cisd.common.multiplexer.BatchesResults;
import ch.systemsx.cisd.common.multiplexer.IBatch;
import ch.systemsx.cisd.common.multiplexer.IBatchHandler;
import ch.systemsx.cisd.common.multiplexer.IBatchIdProvider;
import ch.systemsx.cisd.common.multiplexer.IMultiplexer;
import ch.systemsx.cisd.common.multiplexer.ThreadPoolMultiplexer;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.DssServiceRpcScreeningHolder;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningBatchHandler;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningFactory;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningMultiplexer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import java.util.List;
import java.util.Map;

public class DssServiceRpcScreeningMultiplexer
implements IDssServiceRpcScreeningMultiplexer {
    private final IMultiplexer multiplexer;
    private final IDssServiceRpcScreeningFactory dssServiceFactory;

    public DssServiceRpcScreeningMultiplexer(IMultiplexer multiplexer, IDssServiceRpcScreeningFactory dssServiceFactory) {
        if (multiplexer == null) {
            throw new IllegalArgumentException("Multiplexer cannot be null");
        }
        if (dssServiceFactory == null) {
            throw new IllegalArgumentException("Dss service factory cannot be null");
        }
        this.multiplexer = multiplexer;
        this.dssServiceFactory = dssServiceFactory;
    }

    @Override
    public <O extends IDatasetIdentifier, R> BatchesResults<String, R> process(List<? extends O> objects, final IDssServiceRpcScreeningBatchHandler<O, R> screeningBatchHandler) {
        IBatchIdProvider batchIdProvider = new IBatchIdProvider<O, String>(){

            public String getBatchId(O object) {
                return object.getDatastoreServerUrl();
            }
        };
        BatchHandlerAbstract batchHandler = new BatchHandlerAbstract<O, String, R>(){

            public List<R> processBatch(IBatch<O, String> batch) {
                DssServiceRpcScreeningHolder dssService = DssServiceRpcScreeningMultiplexer.this.dssServiceFactory.createDssService((String)batch.getId());
                return screeningBatchHandler.handle(dssService, batch.getObjects());
            }
        };
        return this.multiplexer.process(objects, batchIdProvider, (IBatchHandler)batchHandler);
    }

    public static Map<String, List<IDatasetIdentifier>> getReferencesPerDataStore(List<IDatasetIdentifier> dataSetIdentifiers) {
        IBatchIdProvider<IDatasetIdentifier, String> batchIdProvider = new IBatchIdProvider<IDatasetIdentifier, String>(){

            public String getBatchId(IDatasetIdentifier object) {
                return object.getDatastoreServerUrl();
            }
        };
        return ThreadPoolMultiplexer.createBatchIdToObjectsMap(dataSetIdentifiers, (IBatchIdProvider)batchIdProvider);
    }
}

