/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageRepresentationFormatSelectionCriterion;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@JsonObject(value="SizeCriterion")
public class SizeCriterion
implements IImageRepresentationFormatSelectionCriterion {
    private static final long serialVersionUID = 1L;
    private static final Comparator<ImageRepresentationFormat> SIZE_COMPARATOR = new Comparator<ImageRepresentationFormat>(){

        @Override
        public int compare(ImageRepresentationFormat i1, ImageRepresentationFormat i2) {
            return this.area(i1) - this.area(i2);
        }

        private int area(ImageRepresentationFormat format) {
            return SizeCriterion.mapNull(format.getWidth()) * SizeCriterion.mapNull(format.getHeight());
        }
    };
    private int width;
    private int height;
    private Type type;

    private static int getWidth(ImageRepresentationFormat format) {
        return SizeCriterion.mapNull(format.getWidth());
    }

    private static int getHeight(ImageRepresentationFormat format) {
        return SizeCriterion.mapNull(format.getHeight());
    }

    private static int mapNull(Integer number) {
        return number == null ? 0 : number;
    }

    public SizeCriterion(int width, int height, Type type) {
        this.width = width;
        this.height = height;
        if (type == null) {
            throw new IllegalArgumentException("Type not specified.");
        }
        this.type = type;
    }

    @Override
    public List<ImageRepresentationFormat> getMatching(List<ImageRepresentationFormat> imageRepresentationFormats) {
        ArrayList<ImageRepresentationFormat> filteredFormats = new ArrayList<ImageRepresentationFormat>();
        this.type.filter(this.width, this.height, imageRepresentationFormats, filteredFormats);
        return filteredFormats;
    }

    private SizeCriterion() {
    }

    private void setWidth(int width) {
        this.width = width;
    }

    private int getWidth() {
        return this.width;
    }

    private void setHeight(int height) {
        this.height = height;
    }

    private int getHeight() {
        return this.height;
    }

    private void setType(Type type) {
        this.type = type;
    }

    private Type getType() {
        return this.type;
    }

    public static enum Type {
        LARGEST_IN_BOUNDING_BOX{

            @Override
            void filter(int width, int height, List<ImageRepresentationFormat> formats, List<ImageRepresentationFormat> filteredFormats) {
                ArrayList<ImageRepresentationFormat> smallerFormats = new ArrayList<ImageRepresentationFormat>();
                INSIDE_BOUNDING_BOX.filter(width, height, formats, smallerFormats);
                if (!smallerFormats.isEmpty()) {
                    Collections.sort(smallerFormats, SIZE_COMPARATOR);
                    filteredFormats.add((ImageRepresentationFormat)smallerFormats.get(smallerFormats.size() - 1));
                }
            }
        }
        ,
        INSIDE_BOUNDING_BOX{

            @Override
            void filter(int width, int height, List<ImageRepresentationFormat> formats, List<ImageRepresentationFormat> filteredFormats) {
                for (ImageRepresentationFormat format : formats) {
                    if (SizeCriterion.getWidth(format) > width || SizeCriterion.getHeight(format) > height) continue;
                    filteredFormats.add(format);
                }
            }
        }
        ,
        SMALLEST_COVERING_BOUNDING_BOX{

            @Override
            void filter(int width, int height, List<ImageRepresentationFormat> formats, List<ImageRepresentationFormat> filteredFormats) {
                ArrayList<ImageRepresentationFormat> largerFormats = new ArrayList<ImageRepresentationFormat>();
                COVERING_BOUNDING_BOX.filter(width, height, formats, largerFormats);
                if (!largerFormats.isEmpty()) {
                    Collections.sort(largerFormats, SIZE_COMPARATOR);
                    filteredFormats.add((ImageRepresentationFormat)largerFormats.get(0));
                }
            }
        }
        ,
        COVERING_BOUNDING_BOX{

            @Override
            void filter(int width, int height, List<ImageRepresentationFormat> formats, List<ImageRepresentationFormat> filteredFormats) {
                for (ImageRepresentationFormat format : formats) {
                    if (SizeCriterion.getWidth(format) < width || SizeCriterion.getHeight(format) < height) continue;
                    filteredFormats.add(format);
                }
            }
        }
        ,
        EXACTLY{

            @Override
            void filter(int width, int height, List<ImageRepresentationFormat> formats, List<ImageRepresentationFormat> filteredFormats) {
                for (ImageRepresentationFormat format : formats) {
                    if (SizeCriterion.getWidth(format) != width || SizeCriterion.getHeight(format) != height) continue;
                    filteredFormats.add(format);
                }
            }
        };


        abstract void filter(int var1, int var2, List<ImageRepresentationFormat> var3, List<ImageRepresentationFormat> var4);
    }
}

