/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.Arrays;

public class WellSearchCriteria
implements Serializable {
    private static final long serialVersionUID = 35L;
    private MaterialSearchCriteria materialCriteria;
    private ExperimentSearchCriteria experimentCriteria;
    private AnalysisProcedureCriteria analysisProcedureCriteria;

    private WellSearchCriteria() {
    }

    public WellSearchCriteria(ExperimentSearchCriteria experimentCriteria, MaterialSearchCriteria materialCriteria, AnalysisProcedureCriteria analysisProcedureCriteria) {
        assert (experimentCriteria != null);
        assert (materialCriteria != null);
        assert (analysisProcedureCriteria != null);
        this.materialCriteria = materialCriteria;
        this.experimentCriteria = experimentCriteria;
        this.analysisProcedureCriteria = analysisProcedureCriteria;
    }

    public String toString() {
        return "Search criteria: " + this.experimentCriteria + ", " + this.materialCriteria + ", " + this.analysisProcedureCriteria;
    }

    public ExperimentSearchCriteria getExperimentCriteria() {
        return this.experimentCriteria;
    }

    public MaterialSearchCriteria getMaterialSearchCriteria() {
        return this.materialCriteria;
    }

    public AnalysisProcedureCriteria getAnalysisProcedureCriteria() {
        return this.analysisProcedureCriteria;
    }

    public static boolean shouldRestrictScopeToProject(ExperimentSearchCriteria searchCriteria) {
        return searchCriteria != null && searchCriteria.tryGetProjectIdentifier() != null;
    }

    public static boolean shouldRestrictScopeToProject(ExperimentSearchByProjectCriteria searchCriteria) {
        return searchCriteria != null && searchCriteria.tryGetProjectIdentifier() != null;
    }

    public static class AbstractMaterialFeaturesCriteria
    implements Serializable {
        private static final long serialVersionUID = 35L;
        private TechId materialId;
        private AnalysisProcedureCriteria analysisProcedureCriteria;

        protected AbstractMaterialFeaturesCriteria() {
        }

        public AbstractMaterialFeaturesCriteria(TechId materialId, AnalysisProcedureCriteria analysisProcedureCriteria) {
            this.materialId = materialId;
            this.analysisProcedureCriteria = analysisProcedureCriteria;
        }

        public TechId getMaterialId() {
            return this.materialId;
        }

        public AnalysisProcedureCriteria getAnalysisProcedureCriteria() {
            return this.analysisProcedureCriteria;
        }
    }

    public static final class AnalysisProcedureCriteria
    implements Serializable {
        private static final long serialVersionUID = 35L;
        private MatchType matchType;
        private String analysisProcedureCodeOrNull;

        public static AnalysisProcedureCriteria createFromCode(String code) {
            if (StringUtils.isBlank((String)code)) {
                throw new IllegalArgumentException("Cannot construct analysis procedure search criteria of this type without a specified code.");
            }
            return new AnalysisProcedureCriteria(MatchType.BY_CODE, code);
        }

        public static AnalysisProcedureCriteria createAllProcedures() {
            return new AnalysisProcedureCriteria(MatchType.ANY, null);
        }

        public static AnalysisProcedureCriteria createNoProcedures() {
            return new AnalysisProcedureCriteria(MatchType.NONE, null);
        }

        private AnalysisProcedureCriteria() {
        }

        private AnalysisProcedureCriteria(MatchType matchType, String analysisProcedureCodeOrNull) {
            this.matchType = matchType;
            this.analysisProcedureCodeOrNull = analysisProcedureCodeOrNull;
        }

        public boolean isAllProcedures() {
            return this.matchType == MatchType.ANY;
        }

        public boolean isNoProcedures() {
            return this.matchType == MatchType.NONE;
        }

        public String tryGetAnalysisProcedureCode() {
            return this.analysisProcedureCodeOrNull;
        }

        public boolean matches(String codeOrNull) {
            if (this.isAllProcedures()) {
                return true;
            }
            if (StringUtils.isBlank((String)codeOrNull)) {
                return this.isNoProcedures();
            }
            return codeOrNull.equals(this.analysisProcedureCodeOrNull);
        }

        public String toString() {
            return "[Analysis procedure code '" + this.analysisProcedureCodeOrNull + "', match = '" + this.matchType + "']";
        }

        public static enum MatchType implements Serializable
        {
            BY_CODE,
            ANY,
            NONE;

        }
    }

    public static final class ExperimentSearchByProjectCriteria
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 35L;
        private BasicProjectIdentifier projectIdOrNull;

        public static final ExperimentSearchByProjectCriteria createAllExperimentsForProject(BasicProjectIdentifier projectIdentifier) {
            if (projectIdentifier == null) {
                throw new IllegalArgumentException("Project identifier cannot be null");
            }
            return new ExperimentSearchByProjectCriteria(projectIdentifier);
        }

        public static final ExperimentSearchByProjectCriteria createAllExperimentsForAllProjects() {
            return new ExperimentSearchByProjectCriteria(null);
        }

        private ExperimentSearchByProjectCriteria() {
        }

        private ExperimentSearchByProjectCriteria(BasicProjectIdentifier projectIdOrNull) {
            this.projectIdOrNull = projectIdOrNull;
        }

        public BasicProjectIdentifier tryGetProjectIdentifier() {
            return this.projectIdOrNull;
        }

        public boolean isAllExperiments() {
            return this.projectIdOrNull == null;
        }

        public ExperimentSearchCriteria asExtendedCriteria() {
            if (this.projectIdOrNull != null) {
                return ExperimentSearchCriteria.createAllExperimentsForProject(this.projectIdOrNull);
            }
            return ExperimentSearchCriteria.createAllExperiments();
        }

        public String toString() {
            if (this.isAllExperiments()) {
                return "all experiments";
            }
            return this.projectIdOrNull.toString();
        }
    }

    public static final class ExperimentSearchCriteria
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 35L;
        private SingleExperimentSearchCriteria experimentOrNull;
        private BasicProjectIdentifier projectIdOrNull;
        private boolean restrictGlobalScopeLinkToProject = false;

        private ExperimentSearchCriteria() {
        }

        public SingleExperimentSearchCriteria tryGetExperiment() {
            return this.experimentOrNull;
        }

        private ExperimentSearchCriteria(SingleExperimentSearchCriteria experimentOrNull, boolean restrictGlobalScopeLinkToProject) {
            this.experimentOrNull = experimentOrNull;
            this.projectIdOrNull = null;
            this.restrictGlobalScopeLinkToProject = restrictGlobalScopeLinkToProject;
        }

        private ExperimentSearchCriteria(BasicProjectIdentifier projectIdOrNull) {
            this.projectIdOrNull = projectIdOrNull;
        }

        public static ExperimentSearchCriteria createExperiment(SingleExperimentSearchCriteria experiment, boolean restrictGlobalScopeLinkToProject) {
            return new ExperimentSearchCriteria(experiment, restrictGlobalScopeLinkToProject);
        }

        public static ExperimentSearchCriteria createExperiment(IEntityInformationHolderWithIdentifier experiment) {
            return ExperimentSearchCriteria.createExperiment(experiment, false);
        }

        public static ExperimentSearchCriteria createExperiment(IEntityInformationHolderWithIdentifier experiment, boolean restrictGlobalScopeLinkToProject) {
            return ExperimentSearchCriteria.createExperiment(new SingleExperimentSearchCriteria(experiment), restrictGlobalScopeLinkToProject);
        }

        public static ExperimentSearchCriteria createAllExperiments() {
            return new ExperimentSearchCriteria(null, false);
        }

        public static final ExperimentSearchCriteria createAllExperimentsForProject(BasicProjectIdentifier projectIdentifier) {
            if (projectIdentifier == null) {
                throw new IllegalArgumentException("Project identifier cannot be null");
            }
            return new ExperimentSearchCriteria(projectIdentifier);
        }

        public BasicProjectIdentifier tryGetProjectIdentifier() {
            return this.projectIdOrNull;
        }

        public boolean getRestrictGlobalSearchLinkToProject() {
            return this.restrictGlobalScopeLinkToProject;
        }

        public ExperimentSearchByProjectCriteria tryAsSearchByProjectCriteria() {
            if (this.tryGetExperiment() != null) {
                return null;
            }
            if (this.projectIdOrNull != null) {
                return ExperimentSearchByProjectCriteria.createAllExperimentsForProject(this.projectIdOrNull);
            }
            return ExperimentSearchByProjectCriteria.createAllExperimentsForAllProjects();
        }

        public String toString() {
            if (this.experimentOrNull == null) {
                if (this.projectIdOrNull == null) {
                    return "all experiments";
                }
                return "all experiments from project " + this.projectIdOrNull;
            }
            return this.experimentOrNull.toString();
        }
    }

    public static final class ExperimentSearchCriteriaHolder {
        private ExperimentSearchCriteria criteriaOrNull;

        public ExperimentSearchCriteriaHolder(ExperimentSearchCriteria criteriaOrNull) {
            this.criteriaOrNull = criteriaOrNull;
        }

        public ExperimentSearchCriteria tryGetCriteria() {
            return this.criteriaOrNull;
        }

        public void setCriteria(ExperimentSearchCriteria criteria) {
            this.criteriaOrNull = criteria;
        }
    }

    public static final class MaterialFeaturesManyExpCriteria
    extends AbstractMaterialFeaturesCriteria
    implements Serializable {
        private static final long serialVersionUID = 35L;
        private ExperimentSearchByProjectCriteria experimentSearchCriteria;
        private boolean computeRanks;

        private MaterialFeaturesManyExpCriteria() {
        }

        public MaterialFeaturesManyExpCriteria(TechId materialId, AnalysisProcedureCriteria analysisProcedureCriteria, ExperimentSearchByProjectCriteria experimentSearchCriteria, boolean computeRanks) {
            super(materialId, analysisProcedureCriteria);
            this.experimentSearchCriteria = experimentSearchCriteria;
            this.computeRanks = computeRanks;
        }

        public ExperimentSearchByProjectCriteria getExperimentSearchCriteria() {
            return this.experimentSearchCriteria;
        }

        public boolean isComputeRanks() {
            return this.computeRanks;
        }
    }

    public static final class MaterialFeaturesOneExpCriteria
    extends AbstractMaterialFeaturesCriteria
    implements Serializable {
        private static final long serialVersionUID = 35L;
        private TechId experimentId;

        private MaterialFeaturesOneExpCriteria() {
        }

        public MaterialFeaturesOneExpCriteria(TechId materialId, AnalysisProcedureCriteria analysisProcedureCriteria, TechId experimentId) {
            super(materialId, analysisProcedureCriteria);
            this.experimentId = experimentId;
        }

        public TechId getExperimentId() {
            return this.experimentId;
        }
    }

    public static final class MaterialSearchCodesCriteria
    implements Serializable {
        private static final long serialVersionUID = 35L;
        private String[] materialCodesOrProperties;
        private String[] materialTypeCodes;
        private boolean exactMatchOnly;

        private MaterialSearchCodesCriteria() {
        }

        public MaterialSearchCodesCriteria(String[] materialCodesOrProperties, String[] materialTypeCodes, boolean exactMatchOnly) {
            this.exactMatchOnly = exactMatchOnly;
            int i = 0;
            while (i < materialCodesOrProperties.length) {
                assert (!StringUtils.isBlank((String)materialCodesOrProperties[i])) : "material search property is blank";
                materialCodesOrProperties[i] = materialCodesOrProperties[i].toUpperCase();
                ++i;
            }
            this.materialCodesOrProperties = materialCodesOrProperties;
            this.materialTypeCodes = materialTypeCodes;
        }

        public String[] getMaterialCodesOrProperties() {
            return this.materialCodesOrProperties;
        }

        public boolean isExactMatchOnly() {
            return this.exactMatchOnly;
        }

        public String[] getMaterialTypeCodes() {
            return this.materialTypeCodes;
        }

        public String toString() {
            return "Material codes (or properties) = " + Arrays.toString(this.materialCodesOrProperties) + ", types = " + Arrays.toString(this.materialTypeCodes) + ", exactMatchOnly = " + this.exactMatchOnly;
        }
    }

    public static final class MaterialSearchCriteria
    implements Serializable {
        private static final long serialVersionUID = 35L;
        private MaterialSearchCodesCriteria codesOrPropertiesCriteriaOrNull;
        private TechId materialIdOrNull;

        public static final MaterialSearchCriteria createCodesCriteria(String[] materialCodes, String[] materialTypeCodes, boolean exactMatchOnly) {
            return MaterialSearchCriteria.create(new MaterialSearchCodesCriteria(materialCodes, materialTypeCodes, exactMatchOnly));
        }

        public static MaterialSearchCriteria create(MaterialSearchCodesCriteria materialCodesCriteria) {
            return new MaterialSearchCriteria(materialCodesCriteria, null);
        }

        public static final MaterialSearchCriteria createIdCriteria(TechId materialId) {
            assert (materialId != null);
            return new MaterialSearchCriteria(null, materialId);
        }

        private MaterialSearchCriteria() {
        }

        private MaterialSearchCriteria(MaterialSearchCodesCriteria codesOrPropertiesCriteriaOrNull, TechId materialIdOrNull) {
            this.codesOrPropertiesCriteriaOrNull = codesOrPropertiesCriteriaOrNull;
            this.materialIdOrNull = materialIdOrNull;
        }

        public MaterialSearchCodesCriteria tryGetMaterialCodesOrProperties() {
            return this.codesOrPropertiesCriteriaOrNull;
        }

        public TechId tryGetMaterialId() {
            return this.materialIdOrNull;
        }

        public String toString() {
            if (this.materialIdOrNull != null) {
                return "Material with id = " + this.materialIdOrNull;
            }
            if (this.codesOrPropertiesCriteriaOrNull != null) {
                return this.codesOrPropertiesCriteriaOrNull.toString();
            }
            throw new IllegalStateException("unexpected material search criteria");
        }
    }

    public static final class SingleExperimentSearchCriteria
    implements Serializable {
        private static final long serialVersionUID = 35L;
        public static final SingleExperimentSearchCriteria EMPTY_CRITERIA = new SingleExperimentSearchCriteria();
        private TechId experimentId;
        private String experimentPermId;
        private String experimentIdentifier;

        private SingleExperimentSearchCriteria() {
        }

        public SingleExperimentSearchCriteria(IEntityInformationHolderWithIdentifier experiment) {
            this(experiment.getId(), experiment.getPermId(), experiment.getIdentifier());
        }

        public SingleExperimentSearchCriteria(long experimentId, String experimentPermId, String experimentIdentifier) {
            this.experimentId = new TechId(Long.valueOf(experimentId));
            this.experimentPermId = experimentPermId;
            this.experimentIdentifier = experimentIdentifier;
        }

        public TechId getExperimentId() {
            return this.experimentId;
        }

        public String getExperimentPermId() {
            return this.experimentPermId;
        }

        public String getExperimentIdentifier() {
            return this.experimentIdentifier;
        }

        public String toString() {
            return "experiment " + this.experimentIdentifier;
        }
    }
}

