/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.utils;

import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.DatabaseEngine;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.springframework.transaction.annotation.Transactional;

public class MaterialShuffler
extends SimpleJdbcDaoSupport {
    private static final ParameterizedRowMapper<Integer> ID_MAPPER = new ParameterizedRowMapper<Integer>(){

        public final Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getInt("id");
        }
    };
    private static final ParameterizedRowMapper<EntityIdMaterialId> ENTITY_ID_MATERIAL_ID_MAPPER = new ParameterizedRowMapper<EntityIdMaterialId>(){

        public final EntityIdMaterialId mapRow(ResultSet rs, int rowNum) throws SQLException {
            Integer entity = rs.getInt("entity_id");
            Integer material = rs.getInt("material_id");
            return new EntityIdMaterialId(entity, material);
        }
    };
    private static final Random GENERATOR = new Random();
    private static final ParameterizedRowMapper<String> CODE_MAPPER = new ParameterizedRowMapper<String>(){

        public String mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString("code");
        }
    };

    public MaterialShuffler(DatabaseConfigurationContext dbConfigurationContext) {
        this.setDataSource(dbConfigurationContext.getDataSource());
    }

    public static void main(String[] args) throws SQLException {
        if (args.length != 1) {
            System.err.println("Specify database kind (eg. productive or demo)");
            System.exit(1);
        }
        DatabaseConfigurationContext dbContext = new DatabaseConfigurationContext();
        dbContext.setDatabaseEngineCode(DatabaseEngine.POSTGRESQL.getCode());
        dbContext.setBasicDatabaseName("openbis");
        dbContext.setDatabaseKind(args[0]);
        new MaterialShuffler(dbContext).shuffle();
    }

    @Transactional
    public void shuffle() {
        try {
            System.out.println("SHUFFLE MATERIALS");
            List<String> entities = Arrays.asList("sample", "experiment", "data_set", "material");
            List<String> material_types = this.listMaterialTypes();
            for (String material_type : material_types) {
                List<Integer> materials = this.listMaterials(material_type);
                for (String entity : entities) {
                    List<EntityIdMaterialId> properties = this.listProperties(material_type, entity);
                    for (EntityIdMaterialId pair : properties) {
                        this.selectNewMaterial(pair, materials);
                    }
                    System.out.print(String.format("Shuffling %s - %s (%s) ...", material_type, entity, properties.size()));
                    this.updateMaterials(entity, properties);
                    System.out.println("DONE.");
                }
            }
            System.out.println("DONE.");
        }
        catch (Exception ex) {
            System.err.println("ERROR: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void updateMaterials(String entity, final List<EntityIdMaterialId> properties) {
        if (properties.size() == 0) {
            return;
        }
        String sql = String.format("update %s_properties set mate_prop_id = ? where id = ? ", entity);
        this.getSimpleJdbcTemplate().getJdbcOperations().batchUpdate(sql, new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return 1000;
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                EntityIdMaterialId entityIdMaterialId = (EntityIdMaterialId)properties.get(i);
                ps.setInt(1, entityIdMaterialId.getNewMaterial());
                ps.setInt(2, entityIdMaterialId.getEntity());
            }
        });
    }

    private void selectNewMaterial(EntityIdMaterialId pair, List<Integer> materials) {
        Integer newMaterial;
        Integer material = pair.getMaterial();
        if (material == null) {
            return;
        }
        while ((newMaterial = materials.get(GENERATOR.nextInt(materials.size()))) == material) {
        }
        pair.setNewMaterial(newMaterial);
    }

    private List<EntityIdMaterialId> listProperties(String material_type, String entity) {
        String propertySql = String.format("select p.id as entity_id, p.mate_prop_id as material_id from %s_properties as p  where p.mate_prop_id is not null and p.mate_prop_id in  (select distinct m.id from materials m, material_types t where m.maty_id=t.id and t.code = ?);", entity);
        return this.getSimpleJdbcTemplate().query(propertySql, ENTITY_ID_MATERIAL_ID_MAPPER, new Object[]{material_type});
    }

    private List<Integer> listMaterials(String material_type) {
        String sql = "select distinct m.id from materials m, material_types t where m.maty_id=t.id and t.code = ?;";
        return this.getSimpleJdbcTemplate().query(sql, ID_MAPPER, new Object[]{material_type});
    }

    private List<String> listMaterialTypes() {
        String sql = "select distinct code from material_types;";
        return this.getSimpleJdbcTemplate().query(sql, CODE_MAPPER, new Object[0]);
    }

    private static class EntityIdMaterialId {
        private final Integer entity;
        private final Integer material;
        private Integer newMaterial;

        public EntityIdMaterialId(Integer entity, Integer material) {
            this.entity = entity;
            this.material = material;
        }

        public Integer getEntity() {
            return this.entity;
        }

        public Integer getMaterial() {
            return this.material;
        }

        public void setNewMaterial(Integer newMaterial) {
            this.newMaterial = newMaterial;
        }

        public Integer getNewMaterial() {
            return this.newMaterial;
        }
    }
}

